// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Kirat_Rai`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x016D40, 0x016D79]
  ]
});
testPropertyEscapes(
  /^\p{Script=Kirat_Rai}+$/u,
  matchSymbols,
  "\\p{Script=Kirat_Rai}"
);
testPropertyEscapes(
  /^\p{Script=Krai}+$/u,
  matchSymbols,
  "\\p{Script=Krai}"
);
testPropertyEscapes(
  /^\p{sc=Kirat_Rai}+$/u,
  matchSymbols,
  "\\p{sc=Kirat_Rai}"
);
testPropertyEscapes(
  /^\p{sc=Krai}+$/u,
  matchSymbols,
  "\\p{sc=Krai}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x016D3F],
    [0x016D7A, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Kirat_Rai}+$/u,
  nonMatchSymbols,
  "\\P{Script=Kirat_Rai}"
);
testPropertyEscapes(
  /^\P{Script=Krai}+$/u,
  nonMatchSymbols,
  "\\P{Script=Krai}"
);
testPropertyEscapes(
  /^\P{sc=Kirat_Rai}+$/u,
  nonMatchSymbols,
  "\\P{sc=Kirat_Rai}"
);
testPropertyEscapes(
  /^\P{sc=Krai}+$/u,
  nonMatchSymbols,
  "\\P{sc=Krai}"
);

reportCompare(0, 0);
