"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PageSection = exports.PageSectionTypes = exports.PageSectionVariants = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const page_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Page/page"));
const react_styles_1 = require("@patternfly/react-styles");
const util_1 = require("../../helpers/util");
const PageContext_1 = require("./PageContext");
const PageBody_1 = require("./PageBody");
var PageSectionVariants;
(function (PageSectionVariants) {
    PageSectionVariants["default"] = "default";
    PageSectionVariants["secondary"] = "secondary";
})(PageSectionVariants || (exports.PageSectionVariants = PageSectionVariants = {}));
var PageSectionTypes;
(function (PageSectionTypes) {
    PageSectionTypes["default"] = "default";
    PageSectionTypes["subNav"] = "subnav";
    PageSectionTypes["breadcrumb"] = "breadcrumb";
    PageSectionTypes["tabs"] = "tabs";
    PageSectionTypes["wizard"] = "wizard";
})(PageSectionTypes || (exports.PageSectionTypes = PageSectionTypes = {}));
const variantType = {
    [PageSectionTypes.default]: page_1.default.pageMainSection,
    [PageSectionTypes.subNav]: page_1.default.pageMainSubnav,
    [PageSectionTypes.breadcrumb]: page_1.default.pageMainBreadcrumb,
    [PageSectionTypes.tabs]: page_1.default.pageMainTabs,
    [PageSectionTypes.wizard]: page_1.default.pageMainWizard
};
const variantStyle = {
    [PageSectionVariants.default]: '',
    [PageSectionVariants.secondary]: page_1.default.modifiers.secondary
};
const PageSection = (_a) => {
    var { className = '', children, variant = 'default', type = 'default', padding, isFilled, isWidthLimited = false, isCenterAligned = false, stickyOnBreakpoint, hasShadowTop = false, hasShadowBottom = false, hasOverflowScroll = false, 'aria-label': ariaLabel, component = 'section', hasBodyWrapper = true } = _a, props = tslib_1.__rest(_a, ["className", "children", "variant", "type", "padding", "isFilled", "isWidthLimited", "isCenterAligned", "stickyOnBreakpoint", "hasShadowTop", "hasShadowBottom", "hasOverflowScroll", 'aria-label', "component", "hasBodyWrapper"]);
    const { height, getVerticalBreakpoint } = (0, react_1.useContext)(PageContext_1.PageContext);
    (0, react_1.useEffect)(() => {
        if (hasOverflowScroll && !ariaLabel) {
            /* eslint-disable no-console */
            console.warn('PageSection: An accessible aria-label is required when hasOverflowScroll is set to true.');
        }
    }, [hasOverflowScroll, ariaLabel]);
    const Component = component;
    return ((0, jsx_runtime_1.jsx)(Component, Object.assign({}, props, { className: (0, react_styles_1.css)(variantType[type], (0, util_1.formatBreakpointMods)(padding, page_1.default), (0, util_1.formatBreakpointMods)(stickyOnBreakpoint, page_1.default, 'sticky-', getVerticalBreakpoint(height), true), type === PageSectionTypes.default && variantStyle[variant], isFilled === false && page_1.default.modifiers.noFill, isFilled === true && page_1.default.modifiers.fill, isWidthLimited && page_1.default.modifiers.limitWidth, isWidthLimited && isCenterAligned && type !== PageSectionTypes.subNav && page_1.default.modifiers.alignCenter, hasShadowTop && page_1.default.modifiers.shadowTop, hasShadowBottom && page_1.default.modifiers.shadowBottom, hasOverflowScroll && page_1.default.modifiers.overflowScroll, className) }, (hasOverflowScroll && { tabIndex: 0 }), { "aria-label": ariaLabel, children: hasBodyWrapper ? (0, jsx_runtime_1.jsx)(PageBody_1.PageBody, { children: children }) : children })));
};
exports.PageSection = PageSection;
exports.PageSection.displayName = 'PageSection';
//# sourceMappingURL=PageSection.js.map