
/*-------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation.  All rights reserved.
 *
 * include/utils/documentdb_errors.h
 *
 * Utilities for documentdb Error Definition.
 * This file is generated - please modify the source (documentdb_errors.csv)
 *
 *-------------------------------------------------------------------------
 */

#ifndef DOCUMENTDB_ERRORS_H
#define DOCUMENTDB_ERRORS_H

#include <utils/elog.h>

/* Represents a Documentdb error */
typedef int DocumentdbErrorEreportCode;
#define ERRCODE_DOCUMENTDB_INTERNALERROR MAKE_SQLSTATE('M', '0', '0', '0', '0')

#define ERRCODE_DOCUMENTDB_BADVALUE MAKE_SQLSTATE('M', '0', '0', '0', '1')

#define ERRCODE_DOCUMENTDB_GRAPHCONTAINSCYCLE MAKE_SQLSTATE('M', '0', '0', '0', '2')

#define ERRCODE_DOCUMENTDB_FAILEDTOPARSE MAKE_SQLSTATE('M', '0', '0', '0', '3')

#define ERRCODE_DOCUMENTDB_TYPEMISMATCH MAKE_SQLSTATE('M', '0', '0', '0', '4')

#define ERRCODE_DOCUMENTDB_OVERFLOW MAKE_SQLSTATE('M', '0', '0', '0', '5')

#define ERRCODE_DOCUMENTDB_ILLEGALOPERATION MAKE_SQLSTATE('M', '0', '0', '0', '6')

#define ERRCODE_DOCUMENTDB_ALREADYINITIALIZED MAKE_SQLSTATE('M', '0', '0', '0', '7')

#define ERRCODE_DOCUMENTDB_NAMESPACENOTFOUND MAKE_SQLSTATE('M', '0', '0', '0', '8')

#define ERRCODE_DOCUMENTDB_INDEXNOTFOUND MAKE_SQLSTATE('M', '0', '0', '0', '9')

#define ERRCODE_DOCUMENTDB_PATHNOTVIABLE MAKE_SQLSTATE('M', '0', '0', '0', 'A')

#define ERRCODE_DOCUMENTDB_ROLENOTFOUND MAKE_SQLSTATE('M', '0', '0', '0', 'B')

#define ERRCODE_DOCUMENTDB_CANNOTBACKFILLARRAY MAKE_SQLSTATE('M', '0', '0', '0', 'C')

#define ERRCODE_DOCUMENTDB_CONFLICTINGUPDATEOPERATORS \
	MAKE_SQLSTATE('M', '0', '0', '0', 'D')

#define ERRCODE_DOCUMENTDB_CURSORNOTFOUND MAKE_SQLSTATE('M', '0', '0', '0', 'E')

#define ERRCODE_DOCUMENTDB_NAMESPACEEXISTS MAKE_SQLSTATE('M', '0', '0', '0', 'F')

#define ERRCODE_DOCUMENTDB_DOLLARPREFIXEDFIELDNAME \
	MAKE_SQLSTATE('M', '0', '0', '0', 'G')

#define ERRCODE_DOCUMENTDB_CANNOTBETYPEARRAY MAKE_SQLSTATE('M', '0', '0', '0', 'H')

#define ERRCODE_DOCUMENTDB_NOTSINGLEVALUEFIELD MAKE_SQLSTATE('M', '0', '0', '0', 'I')

#define ERRCODE_DOCUMENTDB_EMPTYFIELDNAME MAKE_SQLSTATE('M', '0', '0', '0', 'J')

#define ERRCODE_DOCUMENTDB_DOTTEDFIELDNAME MAKE_SQLSTATE('M', '0', '0', '0', 'K')

#define ERRCODE_DOCUMENTDB_SHARDKEYNOTFOUND MAKE_SQLSTATE('M', '0', '0', '0', 'L')

#define ERRCODE_DOCUMENTDB_IMMUTABLEFIELD MAKE_SQLSTATE('M', '0', '0', '0', 'M')

#define ERRCODE_DOCUMENTDB_CANNOTCREATEINDEX MAKE_SQLSTATE('M', '0', '0', '0', 'N')

#define ERRCODE_DOCUMENTDB_INDEXALREADYEXISTS MAKE_SQLSTATE('M', '0', '0', '0', 'O')

#define ERRCODE_DOCUMENTDB_INVALIDOPTIONS MAKE_SQLSTATE('M', '0', '0', '0', 'P')

#define ERRCODE_DOCUMENTDB_INVALIDNAMESPACE MAKE_SQLSTATE('M', '0', '0', '0', 'Q')

#define ERRCODE_DOCUMENTDB_INDEXOPTIONSCONFLICT MAKE_SQLSTATE('M', '0', '0', '0', 'R')

#define ERRCODE_DOCUMENTDB_INDEXKEYSPECSCONFLICT MAKE_SQLSTATE('M', '0', '0', '0', 'S')

#define ERRCODE_DOCUMENTDB_NOTEXACTVALUEFIELD MAKE_SQLSTATE('M', '0', '0', '0', 'T')

#define ERRCODE_DOCUMENTDB_COMMANDNOTSUPPORTED MAKE_SQLSTATE('M', '0', '0', '0', 'U')

#define ERRCODE_DOCUMENTDB_NAMESPACENOTSHARDED MAKE_SQLSTATE('M', '0', '0', '0', 'V')

#define ERRCODE_DOCUMENTDB_EXCEEDEDMEMORYLIMIT MAKE_SQLSTATE('M', '0', '0', '0', 'W')

#define ERRCODE_DOCUMENTDB_DURATIONOVERFLOW MAKE_SQLSTATE('M', '0', '0', '0', 'X')

#define ERRCODE_DOCUMENTDB_VIEWDEPTHLIMITEXCEEDED \
	MAKE_SQLSTATE('M', '0', '0', '0', 'Y')

#define ERRCODE_DOCUMENTDB_COMMANDNOTSUPPORTEDONVIEW \
	MAKE_SQLSTATE('M', '0', '0', '0', 'Z')

#define ERRCODE_DOCUMENTDB_OPTIONNOTSUPPORTEDONVIEW \
	MAKE_SQLSTATE('M', '0', '0', '1', '0')

#define ERRCODE_DOCUMENTDB_AMBIGUOUSINDEXKEYPATTERN \
	MAKE_SQLSTATE('M', '0', '0', '1', '1')

#define ERRCODE_DOCUMENTDB_INVALIDINDEXSPECIFICATIONOPTION \
	MAKE_SQLSTATE('M', '0', '0', '1', '2')

#define ERRCODE_DOCUMENTDB_QUERYFEATURENOTALLOWED \
	MAKE_SQLSTATE('M', '0', '0', '1', '3')

#define ERRCODE_DOCUMENTDB_MAXSUBPIPELINEDEPTHEXCEEDED \
	MAKE_SQLSTATE('M', '0', '0', '1', '4')

#define ERRCODE_DOCUMENTDB_CONVERSIONFAILURE MAKE_SQLSTATE('M', '0', '0', '1', '5')

#define ERRCODE_DOCUMENTDB_OPERATIONNOTSUPPORTEDINTRANSACTION \
	MAKE_SQLSTATE('M', '0', '0', '1', '6')

#define ERRCODE_DOCUMENTDB_INDEXBUILDABORTED MAKE_SQLSTATE('M', '0', '0', '1', '7')

#define ERRCODE_DOCUMENTDB_UNABLETOFINDINDEX MAKE_SQLSTATE('M', '0', '0', '1', '8')

#define ERRCODE_DOCUMENTDB_COLLECTIONUUIDMISMATCH \
	MAKE_SQLSTATE('M', '0', '0', '1', '9')

#define ERRCODE_DOCUMENTDB_LOCATION10065 MAKE_SQLSTATE('M', '0', '0', '1', 'A')

#define ERRCODE_DOCUMENTDB_BSONOBJECTTOOLARGE MAKE_SQLSTATE('M', '0', '0', '1', 'B')

#define ERRCODE_DOCUMENTDB_DUPLICATEKEY MAKE_SQLSTATE('M', '0', '0', '1', 'C')

#define ERRCODE_DOCUMENTDB_BACKGROUNDOPERATIONINPROGRESSFORNAMESPACE \
	MAKE_SQLSTATE('M', '0', '0', '1', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION13026 MAKE_SQLSTATE('M', '0', '0', '1', 'E')

#define ERRCODE_DOCUMENTDB_LOCATION13027 MAKE_SQLSTATE('M', '0', '0', '1', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION13068 MAKE_SQLSTATE('M', '0', '0', '1', 'G')

#define ERRCODE_DOCUMENTDB_MERGESTAGENOMATCHINGDOCUMENT \
	MAKE_SQLSTATE('M', '0', '0', '1', 'H')

#define ERRCODE_DOCUMENTDB_DBALREADYEXISTS MAKE_SQLSTATE('M', '0', '0', '1', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION13548 MAKE_SQLSTATE('M', '0', '0', '1', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION15947 MAKE_SQLSTATE('M', '0', '0', '1', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION15952 MAKE_SQLSTATE('M', '0', '0', '1', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION15955 MAKE_SQLSTATE('M', '0', '0', '1', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION15957 MAKE_SQLSTATE('M', '0', '0', '1', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION15958 MAKE_SQLSTATE('M', '0', '0', '1', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION15959 MAKE_SQLSTATE('M', '0', '0', '1', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION15972 MAKE_SQLSTATE('M', '0', '0', '1', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION15976 MAKE_SQLSTATE('M', '0', '0', '1', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION15981 MAKE_SQLSTATE('M', '0', '0', '1', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION16004 MAKE_SQLSTATE('M', '0', '0', '1', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION16006 MAKE_SQLSTATE('M', '0', '0', '1', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION16007 MAKE_SQLSTATE('M', '0', '0', '1', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION16020 MAKE_SQLSTATE('M', '0', '0', '1', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION6045000 MAKE_SQLSTATE('M', '0', '0', '1', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION16034 MAKE_SQLSTATE('M', '0', '0', '1', 'Y')

#define ERRCODE_DOCUMENTDB_LOCATION16035 MAKE_SQLSTATE('M', '0', '0', '1', 'Z')

#define ERRCODE_DOCUMENTDB_LOCATION16410 MAKE_SQLSTATE('M', '0', '0', '2', '0')

#define ERRCODE_DOCUMENTDB_LOCATION16411 MAKE_SQLSTATE('M', '0', '0', '2', '1')

#define ERRCODE_DOCUMENTDB_LOCATION16433 MAKE_SQLSTATE('M', '0', '0', '2', '2')

#define ERRCODE_DOCUMENTDB_DOLLARADDNUMERICORDATETYPES \
	MAKE_SQLSTATE('M', '0', '0', '2', '3')

#define ERRCODE_DOCUMENTDB_DOLLARMODBYZEROPROHIBITED \
	MAKE_SQLSTATE('M', '0', '0', '2', '4')

#define ERRCODE_DOCUMENTDB_DOLLARMODONLYNUMERIC MAKE_SQLSTATE('M', '0', '0', '2', '5')

#define ERRCODE_DOCUMENTDB_DOLLARADDONLYONEDATE MAKE_SQLSTATE('M', '0', '0', '2', '6')

#define ERRCODE_DOCUMENTDB_LOCATION16702 MAKE_SQLSTATE('M', '0', '0', '2', '7')

#define ERRCODE_DOCUMENTDB_LOCATION16747 MAKE_SQLSTATE('M', '0', '0', '2', '8')

#define ERRCODE_DOCUMENTDB_LOCATION16748 MAKE_SQLSTATE('M', '0', '0', '2', '9')

#define ERRCODE_DOCUMENTDB_LOCATION16749 MAKE_SQLSTATE('M', '0', '0', '2', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION16755 MAKE_SQLSTATE('M', '0', '0', '2', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION16764 MAKE_SQLSTATE('M', '0', '0', '2', 'C')

#define ERRCODE_DOCUMENTDB_HASHEDINDEXDONOTSUPPORTARRAYVALUES \
	MAKE_SQLSTATE('M', '0', '0', '2', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION16800 MAKE_SQLSTATE('M', '0', '0', '2', 'E')

#define ERRCODE_DOCUMENTDB_LOCATION16801 MAKE_SQLSTATE('M', '0', '0', '2', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION16804 MAKE_SQLSTATE('M', '0', '0', '2', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION16874 MAKE_SQLSTATE('M', '0', '0', '2', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION16875 MAKE_SQLSTATE('M', '0', '0', '2', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION16876 MAKE_SQLSTATE('M', '0', '0', '2', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION16878 MAKE_SQLSTATE('M', '0', '0', '2', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION16879 MAKE_SQLSTATE('M', '0', '0', '2', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION16880 MAKE_SQLSTATE('M', '0', '0', '2', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION16882 MAKE_SQLSTATE('M', '0', '0', '2', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION16883 MAKE_SQLSTATE('M', '0', '0', '2', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION16994 MAKE_SQLSTATE('M', '0', '0', '2', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION17040 MAKE_SQLSTATE('M', '0', '0', '2', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION17041 MAKE_SQLSTATE('M', '0', '0', '2', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION17042 MAKE_SQLSTATE('M', '0', '0', '2', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION17043 MAKE_SQLSTATE('M', '0', '0', '2', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION17044 MAKE_SQLSTATE('M', '0', '0', '2', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION17045 MAKE_SQLSTATE('M', '0', '0', '2', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION17046 MAKE_SQLSTATE('M', '0', '0', '2', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION17047 MAKE_SQLSTATE('M', '0', '0', '2', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION17048 MAKE_SQLSTATE('M', '0', '0', '2', 'Y')

#define ERRCODE_DOCUMENTDB_LOCATION17049 MAKE_SQLSTATE('M', '0', '0', '2', 'Z')

#define ERRCODE_DOCUMENTDB_DOLLARCONDMISSINGIFPARAMETER \
	MAKE_SQLSTATE('M', '0', '0', '3', '0')

#define ERRCODE_DOCUMENTDB_DOLLARCONDMISSINGTHENPARAMETER \
	MAKE_SQLSTATE('M', '0', '0', '3', '1')

#define ERRCODE_DOCUMENTDB_DOLLARCONDMISSINGELSEPARAMETER \
	MAKE_SQLSTATE('M', '0', '0', '3', '2')

#define ERRCODE_DOCUMENTDB_DOLLARCONDBADPARAMETER \
	MAKE_SQLSTATE('M', '0', '0', '3', '3')

#define ERRCODE_DOCUMENTDB_DOLLARSIZEREQUIRESARRAY \
	MAKE_SQLSTATE('M', '0', '0', '3', '4')

#define ERRCODE_DOCUMENTDB_EXACTLYONETEXTINDEX MAKE_SQLSTATE('M', '0', '0', '3', '5')

#define ERRCODE_DOCUMENTDB_LOCATION17261 MAKE_SQLSTATE('M', '0', '0', '3', '6')

#define ERRCODE_DOCUMENTDB_LOCATION17276 MAKE_SQLSTATE('M', '0', '0', '3', '7')

#define ERRCODE_DOCUMENTDB_LOCATION17308 MAKE_SQLSTATE('M', '0', '0', '3', '8')

#define ERRCODE_DOCUMENTDB_LOCATION17310 MAKE_SQLSTATE('M', '0', '0', '3', '9')

#define ERRCODE_DOCUMENTDB_DOCUMENTAFTERUPDATELARGERTHANMAXSIZE \
	MAKE_SQLSTATE('M', '0', '0', '3', 'A')

#define ERRCODE_DOCUMENTDB_DOCUMENTTOUPSERTLARGERTHANMAXSIZE \
	MAKE_SQLSTATE('M', '0', '0', '3', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION18628 MAKE_SQLSTATE('M', '0', '0', '3', 'C')

#define ERRCODE_DOCUMENTDB_LOCATION18629 MAKE_SQLSTATE('M', '0', '0', '3', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION18533 MAKE_SQLSTATE('M', '0', '0', '3', 'E')

#define ERRCODE_DOCUMENTDB_LOCATION18534 MAKE_SQLSTATE('M', '0', '0', '3', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION18535 MAKE_SQLSTATE('M', '0', '0', '3', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION18536 MAKE_SQLSTATE('M', '0', '0', '3', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION18537 MAKE_SQLSTATE('M', '0', '0', '3', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION28625 MAKE_SQLSTATE('M', '0', '0', '3', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION28646 MAKE_SQLSTATE('M', '0', '0', '3', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION28647 MAKE_SQLSTATE('M', '0', '0', '3', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION28648 MAKE_SQLSTATE('M', '0', '0', '3', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION28650 MAKE_SQLSTATE('M', '0', '0', '3', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION28651 MAKE_SQLSTATE('M', '0', '0', '3', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION28656 MAKE_SQLSTATE('M', '0', '0', '3', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION28657 MAKE_SQLSTATE('M', '0', '0', '3', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION28664 MAKE_SQLSTATE('M', '0', '0', '3', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION51044 MAKE_SQLSTATE('M', '0', '0', '3', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION51045 MAKE_SQLSTATE('M', '0', '0', '3', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION50989 MAKE_SQLSTATE('M', '0', '0', '3', 'U')

#define ERRCODE_DOCUMENTDB_RANGEARGUMENTEXPRESSIONARGSOUTOFRANGE \
	MAKE_SQLSTATE('M', '0', '0', '3', 'V')

#define ERRCODE_DOCUMENTDB_DOLLARABSCANTTAKELONGMINVALUE \
	MAKE_SQLSTATE('M', '0', '0', '3', 'W')

#define ERRCODE_DOCUMENTDB_ARRAYOPERATORELEMATFIRSTARGMUSTBEARRAY \
	MAKE_SQLSTATE('M', '0', '0', '3', 'X')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYELEMATSECONDARGARGMUSTBENUMERIC \
	MAKE_SQLSTATE('M', '0', '0', '3', 'Y')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYELEMATSECONDARGARGMUSTBE32BIT \
	MAKE_SQLSTATE('M', '0', '0', '3', 'Z')

#define ERRCODE_DOCUMENTDB_DOLLARSQRTGREATEROREQUALTOZERO \
	MAKE_SQLSTATE('M', '0', '0', '4', '0')

#define ERRCODE_DOCUMENTDB_DOLLARSLICEINVALIDINPUT \
	MAKE_SQLSTATE('M', '0', '0', '4', '1')

#define ERRCODE_DOCUMENTDB_DOLLARSLICEINVALIDTYPESECONDARG \
	MAKE_SQLSTATE('M', '0', '0', '4', '2')

#define ERRCODE_DOCUMENTDB_DOLLARSLICEINVALIDVALUESECONDARG \
	MAKE_SQLSTATE('M', '0', '0', '4', '3')

#define ERRCODE_DOCUMENTDB_DOLLARSLICEINVALIDTYPETHIRDARG \
	MAKE_SQLSTATE('M', '0', '0', '4', '4')

#define ERRCODE_DOCUMENTDB_DOLLARSLICEINVALIDVALUETHIRDARG \
	MAKE_SQLSTATE('M', '0', '0', '4', '5')

#define ERRCODE_DOCUMENTDB_DOLLARSLICEINVALIDSIGNTHIRDARG \
	MAKE_SQLSTATE('M', '0', '0', '4', '6')

#define ERRCODE_DOCUMENTDB_LOCATION28745 MAKE_SQLSTATE('M', '0', '0', '4', '7')

#define ERRCODE_DOCUMENTDB_LOCATION28746 MAKE_SQLSTATE('M', '0', '0', '4', '8')

#define ERRCODE_DOCUMENTDB_LOCATION28747 MAKE_SQLSTATE('M', '0', '0', '4', '9')

#define ERRCODE_DOCUMENTDB_LOCATION28748 MAKE_SQLSTATE('M', '0', '0', '4', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION28749 MAKE_SQLSTATE('M', '0', '0', '4', 'B')

#define ERRCODE_DOCUMENTDB_DOLLARLOGARGUMENTMUSTBENUMERIC \
	MAKE_SQLSTATE('M', '0', '0', '4', 'C')

#define ERRCODE_DOCUMENTDB_DOLLARLOGBASEMUSTBENUMERIC \
	MAKE_SQLSTATE('M', '0', '0', '4', 'D')

#define ERRCODE_DOCUMENTDB_DOLLARLOGNUMBERMUSTBEPOSITIVE \
	MAKE_SQLSTATE('M', '0', '0', '4', 'E')

#define ERRCODE_DOCUMENTDB_DOLLARLOGBASEMUSTBEGREATERTHANONE \
	MAKE_SQLSTATE('M', '0', '0', '4', 'F')

#define ERRCODE_DOCUMENTDB_DOLLARLOG10MUSTBEPOSITIVENUMBER \
	MAKE_SQLSTATE('M', '0', '0', '4', 'G')

#define ERRCODE_DOCUMENTDB_DOLLARPOWBASEMUSTBENUMERIC \
	MAKE_SQLSTATE('M', '0', '0', '4', 'H')

#define ERRCODE_DOCUMENTDB_DOLLARPOWEXPONENTMUSTBENUMERIC \
	MAKE_SQLSTATE('M', '0', '0', '4', 'I')

#define ERRCODE_DOCUMENTDB_DOLLARPOWEXPONENTINVALIDFORZEROBASE \
	MAKE_SQLSTATE('M', '0', '0', '4', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION28765 MAKE_SQLSTATE('M', '0', '0', '4', 'K')

#define ERRCODE_DOCUMENTDB_DOLLARLNMUSTBEPOSITIVENUMBER \
	MAKE_SQLSTATE('M', '0', '0', '4', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION28769 MAKE_SQLSTATE('M', '0', '0', '4', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION28803 MAKE_SQLSTATE('M', '0', '0', '4', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION28808 MAKE_SQLSTATE('M', '0', '0', '4', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION28809 MAKE_SQLSTATE('M', '0', '0', '4', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION28810 MAKE_SQLSTATE('M', '0', '0', '4', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION28811 MAKE_SQLSTATE('M', '0', '0', '4', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION28812 MAKE_SQLSTATE('M', '0', '0', '4', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION28818 MAKE_SQLSTATE('M', '0', '0', '4', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION28822 MAKE_SQLSTATE('M', '0', '0', '4', 'U')

#define ERRCODE_DOCUMENTDB_KEYCANNOTCONTAINNULLBYTE \
	MAKE_SQLSTATE('M', '0', '0', '4', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION31002 MAKE_SQLSTATE('M', '0', '0', '4', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION31022 MAKE_SQLSTATE('M', '0', '0', '4', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION31023 MAKE_SQLSTATE('M', '0', '0', '4', 'Y')

#define ERRCODE_DOCUMENTDB_LOCATION31024 MAKE_SQLSTATE('M', '0', '0', '4', 'Z')

#define ERRCODE_DOCUMENTDB_LOCATION31034 MAKE_SQLSTATE('M', '0', '0', '5', '0')

#define ERRCODE_DOCUMENTDB_LOCATION31095 MAKE_SQLSTATE('M', '0', '0', '5', '1')

#define ERRCODE_DOCUMENTDB_LOCATION31109 MAKE_SQLSTATE('M', '0', '0', '5', '2')

#define ERRCODE_DOCUMENTDB_LOCATION31119 MAKE_SQLSTATE('M', '0', '0', '5', '3')

#define ERRCODE_DOCUMENTDB_LOCATION31120 MAKE_SQLSTATE('M', '0', '0', '5', '4')

#define ERRCODE_DOCUMENTDB_LOCATION31138 MAKE_SQLSTATE('M', '0', '0', '5', '5')

#define ERRCODE_DOCUMENTDB_LOCATION31249 MAKE_SQLSTATE('M', '0', '0', '5', '6')

#define ERRCODE_DOCUMENTDB_LOCATION31250 MAKE_SQLSTATE('M', '0', '0', '5', '7')

#define ERRCODE_DOCUMENTDB_LOCATION31253 MAKE_SQLSTATE('M', '0', '0', '5', '8')

#define ERRCODE_DOCUMENTDB_LOCATION31254 MAKE_SQLSTATE('M', '0', '0', '5', '9')

#define ERRCODE_DOCUMENTDB_LOCATION31256 MAKE_SQLSTATE('M', '0', '0', '5', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION31271 MAKE_SQLSTATE('M', '0', '0', '5', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION31276 MAKE_SQLSTATE('M', '0', '0', '5', 'C')

#define ERRCODE_DOCUMENTDB_LOCATION31308 MAKE_SQLSTATE('M', '0', '0', '5', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION31325 MAKE_SQLSTATE('M', '0', '0', '5', 'E')

#define ERRCODE_DOCUMENTDB_LOCATION31393 MAKE_SQLSTATE('M', '0', '0', '5', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION31395 MAKE_SQLSTATE('M', '0', '0', '5', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION34435 MAKE_SQLSTATE('M', '0', '0', '5', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION31441 MAKE_SQLSTATE('M', '0', '0', '5', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION34443 MAKE_SQLSTATE('M', '0', '0', '5', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION34444 MAKE_SQLSTATE('M', '0', '0', '5', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION34445 MAKE_SQLSTATE('M', '0', '0', '5', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION34446 MAKE_SQLSTATE('M', '0', '0', '5', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION34447 MAKE_SQLSTATE('M', '0', '0', '5', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION34448 MAKE_SQLSTATE('M', '0', '0', '5', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION34449 MAKE_SQLSTATE('M', '0', '0', '5', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION34450 MAKE_SQLSTATE('M', '0', '0', '5', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION34451 MAKE_SQLSTATE('M', '0', '0', '5', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION34452 MAKE_SQLSTATE('M', '0', '0', '5', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION34453 MAKE_SQLSTATE('M', '0', '0', '5', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION34454 MAKE_SQLSTATE('M', '0', '0', '5', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION34455 MAKE_SQLSTATE('M', '0', '0', '5', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION34460 MAKE_SQLSTATE('M', '0', '0', '5', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION34461 MAKE_SQLSTATE('M', '0', '0', '5', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION34462 MAKE_SQLSTATE('M', '0', '0', '5', 'Y')

#define ERRCODE_DOCUMENTDB_LOCATION34463 MAKE_SQLSTATE('M', '0', '0', '5', 'Z')

#define ERRCODE_DOCUMENTDB_LOCATION34464 MAKE_SQLSTATE('M', '0', '0', '6', '0')

#define ERRCODE_DOCUMENTDB_LOCATION34465 MAKE_SQLSTATE('M', '0', '0', '6', '1')

#define ERRCODE_DOCUMENTDB_LOCATION34466 MAKE_SQLSTATE('M', '0', '0', '6', '2')

#define ERRCODE_DOCUMENTDB_LOCATION34467 MAKE_SQLSTATE('M', '0', '0', '6', '3')

#define ERRCODE_DOCUMENTDB_LOCATION34468 MAKE_SQLSTATE('M', '0', '0', '6', '4')

#define ERRCODE_DOCUMENTDB_LOCATION34471 MAKE_SQLSTATE('M', '0', '0', '6', '5')

#define ERRCODE_DOCUMENTDB_LOCATION34473 MAKE_SQLSTATE('M', '0', '0', '6', '6')

#define ERRCODE_DOCUMENTDB_DOLLARSWITCHREQUIRESOBJECT \
	MAKE_SQLSTATE('M', '0', '0', '6', '7')

#define ERRCODE_DOCUMENTDB_DOLLARSWITCHREQUIRESARRAYFORBRANCHES \
	MAKE_SQLSTATE('M', '0', '0', '6', '8')

#define ERRCODE_DOCUMENTDB_DOLLARSWITCHREQUIRESOBJECTFOREACHBRANCH \
	MAKE_SQLSTATE('M', '0', '0', '6', '9')

#define ERRCODE_DOCUMENTDB_DOLLARSWITCHUNKNOWNARGUMENTFORBRANCH \
	MAKE_SQLSTATE('M', '0', '0', '6', 'A')

#define ERRCODE_DOCUMENTDB_DOLLARSWITCHREQUIRESCASEEXPRESSIONFORBRANCH \
	MAKE_SQLSTATE('M', '0', '0', '6', 'B')

#define ERRCODE_DOCUMENTDB_DOLLARSWITCHREQUIRESTHENEXPRESSIONFORBRANCH \
	MAKE_SQLSTATE('M', '0', '0', '6', 'C')

#define ERRCODE_DOCUMENTDB_DOLLARSWITCHNOMATCHINGBRANCHANDNODEFAULT \
	MAKE_SQLSTATE('M', '0', '0', '6', 'D')

#define ERRCODE_DOCUMENTDB_DOLLARSWITCHBADARGUMENT \
	MAKE_SQLSTATE('M', '0', '0', '6', 'E')

#define ERRCODE_DOCUMENTDB_DOLLARSWITCHREQUIRESATLEASTONEBRANCH \
	MAKE_SQLSTATE('M', '0', '0', '6', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION40075 MAKE_SQLSTATE('M', '0', '0', '6', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION40076 MAKE_SQLSTATE('M', '0', '0', '6', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION40077 MAKE_SQLSTATE('M', '0', '0', '6', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION40078 MAKE_SQLSTATE('M', '0', '0', '6', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION40079 MAKE_SQLSTATE('M', '0', '0', '6', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION40080 MAKE_SQLSTATE('M', '0', '0', '6', 'L')

#define ERRCODE_DOCUMENTDB_DOLLARINREQUIRESARRAY MAKE_SQLSTATE('M', '0', '0', '6', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION40085 MAKE_SQLSTATE('M', '0', '0', '6', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION40086 MAKE_SQLSTATE('M', '0', '0', '6', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION40087 MAKE_SQLSTATE('M', '0', '0', '6', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION40090 MAKE_SQLSTATE('M', '0', '0', '6', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION40091 MAKE_SQLSTATE('M', '0', '0', '6', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION40092 MAKE_SQLSTATE('M', '0', '0', '6', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION40093 MAKE_SQLSTATE('M', '0', '0', '6', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION40094 MAKE_SQLSTATE('M', '0', '0', '6', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION40096 MAKE_SQLSTATE('M', '0', '0', '6', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION40097 MAKE_SQLSTATE('M', '0', '0', '6', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION40100 MAKE_SQLSTATE('M', '0', '0', '6', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION40101 MAKE_SQLSTATE('M', '0', '0', '6', 'Y')

#define ERRCODE_DOCUMENTDB_LOCATION40102 MAKE_SQLSTATE('M', '0', '0', '6', 'Z')

#define ERRCODE_DOCUMENTDB_LOCATION40103 MAKE_SQLSTATE('M', '0', '0', '7', '0')

#define ERRCODE_DOCUMENTDB_LOCATION40104 MAKE_SQLSTATE('M', '0', '0', '7', '1')

#define ERRCODE_DOCUMENTDB_LOCATION40105 MAKE_SQLSTATE('M', '0', '0', '7', '2')

#define ERRCODE_DOCUMENTDB_LOCATION40147 MAKE_SQLSTATE('M', '0', '0', '7', '3')

#define ERRCODE_DOCUMENTDB_LOCATION40156 MAKE_SQLSTATE('M', '0', '0', '7', '4')

#define ERRCODE_DOCUMENTDB_LOCATION40158 MAKE_SQLSTATE('M', '0', '0', '7', '5')

#define ERRCODE_DOCUMENTDB_LOCATION40160 MAKE_SQLSTATE('M', '0', '0', '7', '6')

#define ERRCODE_DOCUMENTDB_LOCATION40169 MAKE_SQLSTATE('M', '0', '0', '7', '7')

#define ERRCODE_DOCUMENTDB_LOCATION40177 MAKE_SQLSTATE('M', '0', '0', '7', '8')

#define ERRCODE_DOCUMENTDB_LOCATION40185 MAKE_SQLSTATE('M', '0', '0', '7', '9')

#define ERRCODE_DOCUMENTDB_LOCATION40191 MAKE_SQLSTATE('M', '0', '0', '7', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION40192 MAKE_SQLSTATE('M', '0', '0', '7', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION40193 MAKE_SQLSTATE('M', '0', '0', '7', 'C')

#define ERRCODE_DOCUMENTDB_LOCATION40194 MAKE_SQLSTATE('M', '0', '0', '7', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION40195 MAKE_SQLSTATE('M', '0', '0', '7', 'E')

#define ERRCODE_DOCUMENTDB_LOCATION40196 MAKE_SQLSTATE('M', '0', '0', '7', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION40197 MAKE_SQLSTATE('M', '0', '0', '7', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION40198 MAKE_SQLSTATE('M', '0', '0', '7', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION40199 MAKE_SQLSTATE('M', '0', '0', '7', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION40200 MAKE_SQLSTATE('M', '0', '0', '7', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION40201 MAKE_SQLSTATE('M', '0', '0', '7', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION40202 MAKE_SQLSTATE('M', '0', '0', '7', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION40218 MAKE_SQLSTATE('M', '0', '0', '7', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION40228 MAKE_SQLSTATE('M', '0', '0', '7', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION40234 MAKE_SQLSTATE('M', '0', '0', '7', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION40238 MAKE_SQLSTATE('M', '0', '0', '7', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION40272 MAKE_SQLSTATE('M', '0', '0', '7', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION40319 MAKE_SQLSTATE('M', '0', '0', '7', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION40321 MAKE_SQLSTATE('M', '0', '0', '7', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION40323 MAKE_SQLSTATE('M', '0', '0', '7', 'T')

#define ERRCODE_DOCUMENTDB_UNRECOGNIZEDCOMMAND MAKE_SQLSTATE('M', '0', '0', '7', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION40352 MAKE_SQLSTATE('M', '0', '0', '7', 'V')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYTOOBJECTREQUIRESARRAY \
	MAKE_SQLSTATE('M', '0', '0', '7', 'W')

#define ERRCODE_DOCUMENTDB_DOLLAROBJECTTOARRAYREQUIRESOBJECT \
	MAKE_SQLSTATE('M', '0', '0', '7', 'X')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYTOOBJECTALLMUSTBEOBJECTS \
	MAKE_SQLSTATE('M', '0', '0', '7', 'Y')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYTOOBJECTINCORRECTNUMBEROFKEYS \
	MAKE_SQLSTATE('M', '0', '0', '7', 'Z')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYTOOBJECTREQUIRESOBJECTWITHKANDV \
	MAKE_SQLSTATE('M', '0', '0', '8', '0')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYTOOBJECTOBJECTKEYMUSTBESTRING \
	MAKE_SQLSTATE('M', '0', '0', '8', '1')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYTOOBJECTARRAYKEYMUSTBESTRING \
	MAKE_SQLSTATE('M', '0', '0', '8', '2')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYTOOBJECTALLMUSTBEARRAYS \
	MAKE_SQLSTATE('M', '0', '0', '8', '3')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYTOOBJECTINCORRECTARRAYLENGTH \
	MAKE_SQLSTATE('M', '0', '0', '8', '4')

#define ERRCODE_DOCUMENTDB_DOLLARARRAYTOOBJECTBADINPUTTYPEFORMAT \
	MAKE_SQLSTATE('M', '0', '0', '8', '5')

#define ERRCODE_DOCUMENTDB_DOLLARMERGEOBJECTSINVALIDTYPE \
	MAKE_SQLSTATE('M', '0', '0', '8', '6')

#define ERRCODE_DOCUMENTDB_LOCATION40414 MAKE_SQLSTATE('M', '0', '0', '8', '7')

#define ERRCODE_DOCUMENTDB_UNKNOWNBSONFIELD MAKE_SQLSTATE('M', '0', '0', '8', '8')

#define ERRCODE_DOCUMENTDB_LOCATION40485 MAKE_SQLSTATE('M', '0', '0', '8', '9')

#define ERRCODE_DOCUMENTDB_LOCATION40489 MAKE_SQLSTATE('M', '0', '0', '8', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION40515 MAKE_SQLSTATE('M', '0', '0', '8', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION40516 MAKE_SQLSTATE('M', '0', '0', '8', 'C')

#define ERRCODE_DOCUMENTDB_LOCATION40517 MAKE_SQLSTATE('M', '0', '0', '8', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION40518 MAKE_SQLSTATE('M', '0', '0', '8', 'E')

#define ERRCODE_DOCUMENTDB_LOCATION40519 MAKE_SQLSTATE('M', '0', '0', '8', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION40520 MAKE_SQLSTATE('M', '0', '0', '8', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION40521 MAKE_SQLSTATE('M', '0', '0', '8', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION40522 MAKE_SQLSTATE('M', '0', '0', '8', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION40523 MAKE_SQLSTATE('M', '0', '0', '8', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION40524 MAKE_SQLSTATE('M', '0', '0', '8', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION40525 MAKE_SQLSTATE('M', '0', '0', '8', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION40533 MAKE_SQLSTATE('M', '0', '0', '8', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION40535 MAKE_SQLSTATE('M', '0', '0', '8', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION40536 MAKE_SQLSTATE('M', '0', '0', '8', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION40539 MAKE_SQLSTATE('M', '0', '0', '8', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION40540 MAKE_SQLSTATE('M', '0', '0', '8', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION40541 MAKE_SQLSTATE('M', '0', '0', '8', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION40542 MAKE_SQLSTATE('M', '0', '0', '8', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION40600 MAKE_SQLSTATE('M', '0', '0', '8', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION40601 MAKE_SQLSTATE('M', '0', '0', '8', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION40602 MAKE_SQLSTATE('M', '0', '0', '8', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION40603 MAKE_SQLSTATE('M', '0', '0', '8', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION40235 MAKE_SQLSTATE('M', '0', '0', '8', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION40237 MAKE_SQLSTATE('M', '0', '0', '8', 'Y')

#define ERRCODE_DOCUMENTDB_CHANGESTREAMBADRESUMETOKEN \
	MAKE_SQLSTATE('M', '0', '0', '8', 'Z')

#define ERRCODE_DOCUMENTDB_LOCATION40684 MAKE_SQLSTATE('M', '0', '0', '9', '0')

#define ERRCODE_DOCUMENTDB_LOCATION50694 MAKE_SQLSTATE('M', '0', '0', '9', '1')

#define ERRCODE_DOCUMENTDB_LOCATION50695 MAKE_SQLSTATE('M', '0', '0', '9', '2')

#define ERRCODE_DOCUMENTDB_LOCATION50696 MAKE_SQLSTATE('M', '0', '0', '9', '3')

#define ERRCODE_DOCUMENTDB_LOCATION50699 MAKE_SQLSTATE('M', '0', '0', '9', '4')

#define ERRCODE_DOCUMENTDB_LOCATION50700 MAKE_SQLSTATE('M', '0', '0', '9', '5')

#define ERRCODE_DOCUMENTDB_LOCATION50723 MAKE_SQLSTATE('M', '0', '0', '9', '6')

#define ERRCODE_DOCUMENTDB_LOCATION50752 MAKE_SQLSTATE('M', '0', '0', '9', '7')

#define ERRCODE_DOCUMENTDB_LOCATION50759 MAKE_SQLSTATE('M', '0', '0', '9', '8')

#define ERRCODE_DOCUMENTDB_LOCATION51024 MAKE_SQLSTATE('M', '0', '0', '9', '9')

#define ERRCODE_DOCUMENTDB_LOCATION51047 MAKE_SQLSTATE('M', '0', '0', '9', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION51074 MAKE_SQLSTATE('M', '0', '0', '9', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION51075 MAKE_SQLSTATE('M', '0', '0', '9', 'C')

#define ERRCODE_DOCUMENTDB_DOLLARROUNDOVERFLOWINT64 \
	MAKE_SQLSTATE('M', '0', '0', '9', 'D')

#define ERRCODE_DOCUMENTDB_DOLLARROUNDFIRSTARGMUSTBENUMERIC \
	MAKE_SQLSTATE('M', '0', '0', '9', 'E')

#define ERRCODE_DOCUMENTDB_DOLLARROUNDPRECISIONMUSTBEINTEGRAL \
	MAKE_SQLSTATE('M', '0', '0', '9', 'F')

#define ERRCODE_DOCUMENTDB_DOLLARROUNDPRECISIONOUTOFRANGE \
	MAKE_SQLSTATE('M', '0', '0', '9', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION51091 MAKE_SQLSTATE('M', '0', '0', '9', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION51103 MAKE_SQLSTATE('M', '0', '0', '9', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION51104 MAKE_SQLSTATE('M', '0', '0', '9', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION51105 MAKE_SQLSTATE('M', '0', '0', '9', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION51106 MAKE_SQLSTATE('M', '0', '0', '9', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION51107 MAKE_SQLSTATE('M', '0', '0', '9', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION51108 MAKE_SQLSTATE('M', '0', '0', '9', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION51109 MAKE_SQLSTATE('M', '0', '0', '9', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION51110 MAKE_SQLSTATE('M', '0', '0', '9', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION51111 MAKE_SQLSTATE('M', '0', '0', '9', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION51132 MAKE_SQLSTATE('M', '0', '0', '9', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION51134 MAKE_SQLSTATE('M', '0', '0', '9', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION51151 MAKE_SQLSTATE('M', '0', '0', '9', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION51156 MAKE_SQLSTATE('M', '0', '0', '9', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION51178 MAKE_SQLSTATE('M', '0', '0', '9', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION51183 MAKE_SQLSTATE('M', '0', '0', '9', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION51185 MAKE_SQLSTATE('M', '0', '0', '9', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION51186 MAKE_SQLSTATE('M', '0', '0', '9', 'Y')

#define ERRCODE_DOCUMENTDB_LOCATION51187 MAKE_SQLSTATE('M', '0', '0', '9', 'Z')

#define ERRCODE_DOCUMENTDB_LOCATION51191 MAKE_SQLSTATE('M', '0', '0', 'A', '0')

#define ERRCODE_DOCUMENTDB_LOCATION51246 MAKE_SQLSTATE('M', '0', '0', 'A', '1')

#define ERRCODE_DOCUMENTDB_LOCATION51276 MAKE_SQLSTATE('M', '0', '0', 'A', '2')

#define ERRCODE_DOCUMENTDB_LOCATION51247 MAKE_SQLSTATE('M', '0', '0', 'A', '3')

#define ERRCODE_DOCUMENTDB_LOCATION51743 MAKE_SQLSTATE('M', '0', '0', 'A', '4')

#define ERRCODE_DOCUMENTDB_LOCATION51744 MAKE_SQLSTATE('M', '0', '0', 'A', '5')

#define ERRCODE_DOCUMENTDB_LOCATION51745 MAKE_SQLSTATE('M', '0', '0', 'A', '6')

#define ERRCODE_DOCUMENTDB_LOCATION51746 MAKE_SQLSTATE('M', '0', '0', 'A', '7')

#define ERRCODE_DOCUMENTDB_LOCATION51747 MAKE_SQLSTATE('M', '0', '0', 'A', '8')

#define ERRCODE_DOCUMENTDB_LOCATION51748 MAKE_SQLSTATE('M', '0', '0', 'A', '9')

#define ERRCODE_DOCUMENTDB_LOCATION51749 MAKE_SQLSTATE('M', '0', '0', 'A', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION51750 MAKE_SQLSTATE('M', '0', '0', 'A', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION51751 MAKE_SQLSTATE('M', '0', '0', 'A', 'C')

#define ERRCODE_DOCUMENTDB_LOCATION327391 MAKE_SQLSTATE('M', '0', '0', 'A', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION327392 MAKE_SQLSTATE('M', '0', '0', 'A', 'E')

#define ERRCODE_DOCUMENTDB_DOLLARIFNULLREQUIRESATLEASTTWOARGS \
	MAKE_SQLSTATE('M', '0', '0', 'A', 'F')

#define ERRCODE_DOCUMENTDB_DOLLARRANDNONEMPTYARGUMENT \
	MAKE_SQLSTATE('M', '0', '0', 'A', 'G')

#define ERRCODE_DOCUMENTDB_INTERMEDIATERESULTTOOLARGE \
	MAKE_SQLSTATE('M', '0', '0', 'A', 'H')

#define ERRCODE_DOCUMENTDB_DOLLARSETFIELDREQUIRESOBJECT \
	MAKE_SQLSTATE('M', '0', '0', 'A', 'I')

#define ERRCODE_DOCUMENTDB_DOLLARSETFIELDUNKNOWNARGUMENT \
	MAKE_SQLSTATE('M', '0', '0', 'A', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION2942500 MAKE_SQLSTATE('M', '0', '0', 'A', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION2942501 MAKE_SQLSTATE('M', '0', '0', 'A', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION2942502 MAKE_SQLSTATE('M', '0', '0', 'A', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION2942503 MAKE_SQLSTATE('M', '0', '0', 'A', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION2942504 MAKE_SQLSTATE('M', '0', '0', 'A', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION2942505 MAKE_SQLSTATE('M', '0', '0', 'A', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION2942506 MAKE_SQLSTATE('M', '0', '0', 'A', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION3041701 MAKE_SQLSTATE('M', '0', '0', 'A', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION3041702 MAKE_SQLSTATE('M', '0', '0', 'A', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION3041703 MAKE_SQLSTATE('M', '0', '0', 'A', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION4161102 MAKE_SQLSTATE('M', '0', '0', 'A', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION4161103 MAKE_SQLSTATE('M', '0', '0', 'A', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION4161104 MAKE_SQLSTATE('M', '0', '0', 'A', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION4161105 MAKE_SQLSTATE('M', '0', '0', 'A', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION4161106 MAKE_SQLSTATE('M', '0', '0', 'A', 'Y')

#define ERRCODE_DOCUMENTDB_LOCATION4161107 MAKE_SQLSTATE('M', '0', '0', 'A', 'Z')

#define ERRCODE_DOCUMENTDB_LOCATION4161108 MAKE_SQLSTATE('M', '0', '0', 'B', '0')

#define ERRCODE_DOCUMENTDB_LOCATION4161109 MAKE_SQLSTATE('M', '0', '0', 'B', '1')

#define ERRCODE_DOCUMENTDB_LOCATION4890500 MAKE_SQLSTATE('M', '0', '0', 'B', '2')

#define ERRCODE_DOCUMENTDB_LOCATION4940400 MAKE_SQLSTATE('M', '0', '0', 'B', '3')

#define ERRCODE_DOCUMENTDB_LOCATION4940401 MAKE_SQLSTATE('M', '0', '0', 'B', '4')

#define ERRCODE_DOCUMENTDB_LOCATION5166400 MAKE_SQLSTATE('M', '0', '0', 'B', '5')

#define ERRCODE_DOCUMENTDB_LOCATION5166401 MAKE_SQLSTATE('M', '0', '0', 'B', '6')

#define ERRCODE_DOCUMENTDB_LOCATION5166402 MAKE_SQLSTATE('M', '0', '0', 'B', '7')

#define ERRCODE_DOCUMENTDB_LOCATION5166403 MAKE_SQLSTATE('M', '0', '0', 'B', '8')

#define ERRCODE_DOCUMENTDB_LOCATION5166404 MAKE_SQLSTATE('M', '0', '0', 'B', '9')

#define ERRCODE_DOCUMENTDB_LOCATION5166405 MAKE_SQLSTATE('M', '0', '0', 'B', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION5166406 MAKE_SQLSTATE('M', '0', '0', 'B', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION5107200 MAKE_SQLSTATE('M', '0', '0', 'B', 'C')

#define ERRCODE_DOCUMENTDB_LOCATION5107201 MAKE_SQLSTATE('M', '0', '0', 'B', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION5166301 MAKE_SQLSTATE('M', '0', '0', 'B', 'E')

#define ERRCODE_DOCUMENTDB_LOCATION5166302 MAKE_SQLSTATE('M', '0', '0', 'B', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION5166303 MAKE_SQLSTATE('M', '0', '0', 'B', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION5166304 MAKE_SQLSTATE('M', '0', '0', 'B', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION5166305 MAKE_SQLSTATE('M', '0', '0', 'B', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION5166307 MAKE_SQLSTATE('M', '0', '0', 'B', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION5339900 MAKE_SQLSTATE('M', '0', '0', 'B', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION5339901 MAKE_SQLSTATE('M', '0', '0', 'B', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION5339902 MAKE_SQLSTATE('M', '0', '0', 'B', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION5429413 MAKE_SQLSTATE('M', '0', '0', 'B', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION5429414 MAKE_SQLSTATE('M', '0', '0', 'B', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION5429513 MAKE_SQLSTATE('M', '0', '0', 'B', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION5439007 MAKE_SQLSTATE('M', '0', '0', 'B', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION5439008 MAKE_SQLSTATE('M', '0', '0', 'B', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION5439009 MAKE_SQLSTATE('M', '0', '0', 'B', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION5439010 MAKE_SQLSTATE('M', '0', '0', 'B', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION5439012 MAKE_SQLSTATE('M', '0', '0', 'B', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION5439013 MAKE_SQLSTATE('M', '0', '0', 'B', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION5439014 MAKE_SQLSTATE('M', '0', '0', 'B', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION5439015 MAKE_SQLSTATE('M', '0', '0', 'B', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION5439016 MAKE_SQLSTATE('M', '0', '0', 'B', 'Y')

#define ERRCODE_DOCUMENTDB_LOCATION5439017 MAKE_SQLSTATE('M', '0', '0', 'B', 'Z')

#define ERRCODE_DOCUMENTDB_LOCATION5439018 MAKE_SQLSTATE('M', '0', '0', 'C', '0')

#define ERRCODE_DOCUMENTDB_LOCATION5626500 MAKE_SQLSTATE('M', '0', '0', 'C', '1')

#define ERRCODE_DOCUMENTDB_LOCATION5654600 MAKE_SQLSTATE('M', '0', '0', 'C', '2')

#define ERRCODE_DOCUMENTDB_LOCATION5654601 MAKE_SQLSTATE('M', '0', '0', 'C', '3')

#define ERRCODE_DOCUMENTDB_LOCATION5654602 MAKE_SQLSTATE('M', '0', '0', 'C', '4')

#define ERRCODE_DOCUMENTDB_LOCATION5687301 MAKE_SQLSTATE('M', '0', '0', 'C', '5')

#define ERRCODE_DOCUMENTDB_LOCATION5687302 MAKE_SQLSTATE('M', '0', '0', 'C', '6')

#define ERRCODE_DOCUMENTDB_LOCATION5687400 MAKE_SQLSTATE('M', '0', '0', 'C', '7')

#define ERRCODE_DOCUMENTDB_LOCATION5687401 MAKE_SQLSTATE('M', '0', '0', 'C', '8')

#define ERRCODE_DOCUMENTDB_LOCATION5746102 MAKE_SQLSTATE('M', '0', '0', 'C', '9')

#define ERRCODE_DOCUMENTDB_LOCATION5787801 MAKE_SQLSTATE('M', '0', '0', 'C', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION5787900 MAKE_SQLSTATE('M', '0', '0', 'C', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION5787901 MAKE_SQLSTATE('M', '0', '0', 'C', 'C')

#define ERRCODE_DOCUMENTDB_LOCATION5787902 MAKE_SQLSTATE('M', '0', '0', 'C', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION5787903 MAKE_SQLSTATE('M', '0', '0', 'C', 'E')

#define ERRCODE_DOCUMENTDB_LOCATION5787906 MAKE_SQLSTATE('M', '0', '0', 'C', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION5787907 MAKE_SQLSTATE('M', '0', '0', 'C', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION5787908 MAKE_SQLSTATE('M', '0', '0', 'C', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION5788200 MAKE_SQLSTATE('M', '0', '0', 'C', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION5858203 MAKE_SQLSTATE('M', '0', '0', 'C', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION5976500 MAKE_SQLSTATE('M', '0', '0', 'C', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION5371601 MAKE_SQLSTATE('M', '0', '0', 'C', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION5371602 MAKE_SQLSTATE('M', '0', '0', 'C', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION5371603 MAKE_SQLSTATE('M', '0', '0', 'C', 'N')

#define ERRCODE_DOCUMENTDB_DOCUMENTFAILEDVALIDATION \
	MAKE_SQLSTATE('M', '0', '0', 'C', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION605001 MAKE_SQLSTATE('M', '0', '0', 'C', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION6050106 MAKE_SQLSTATE('M', '0', '0', 'C', 'Q')

#define ERRCODE_DOCUMENTDB_LOCATION16990 MAKE_SQLSTATE('M', '0', '0', 'C', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION13111 MAKE_SQLSTATE('M', '0', '0', 'C', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION5788001 MAKE_SQLSTATE('M', '0', '0', 'C', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION5788002 MAKE_SQLSTATE('M', '0', '0', 'C', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION5788003 MAKE_SQLSTATE('M', '0', '0', 'C', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION5788004 MAKE_SQLSTATE('M', '0', '0', 'C', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION5788005 MAKE_SQLSTATE('M', '0', '0', 'C', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION5733201 MAKE_SQLSTATE('M', '0', '0', 'C', 'Y')

#define ERRCODE_DOCUMENTDB_LOCATION5733401 MAKE_SQLSTATE('M', '0', '0', 'C', 'Z')

#define ERRCODE_DOCUMENTDB_LOCATION5733402 MAKE_SQLSTATE('M', '0', '0', 'D', '0')

#define ERRCODE_DOCUMENTDB_LOCATION5733403 MAKE_SQLSTATE('M', '0', '0', 'D', '1')

#define ERRCODE_DOCUMENTDB_LOCATION5733406 MAKE_SQLSTATE('M', '0', '0', 'D', '2')

#define ERRCODE_DOCUMENTDB_LOCATION5733408 MAKE_SQLSTATE('M', '0', '0', 'D', '3')

#define ERRCODE_DOCUMENTDB_LOCATION5733409 MAKE_SQLSTATE('M', '0', '0', 'D', '4')

#define ERRCODE_DOCUMENTDB_LOCATION5876900 MAKE_SQLSTATE('M', '0', '0', 'D', '5')

#define ERRCODE_DOCUMENTDB_LOCATION5897900 MAKE_SQLSTATE('M', '0', '0', 'D', '6')

#define ERRCODE_DOCUMENTDB_LOCATION5946802 MAKE_SQLSTATE('M', '0', '0', 'D', '7')

#define ERRCODE_DOCUMENTDB_LOCATION6007200 MAKE_SQLSTATE('M', '0', '0', 'D', '8')

#define ERRCODE_DOCUMENTDB_LOCATION6053600 MAKE_SQLSTATE('M', '0', '0', 'D', '9')

#define ERRCODE_DOCUMENTDB_LOCATION6586400 MAKE_SQLSTATE('M', '0', '0', 'D', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION8993000 MAKE_SQLSTATE('M', '0', '0', 'D', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION5423900 MAKE_SQLSTATE('M', '0', '0', 'D', 'C')

#define ERRCODE_DOCUMENTDB_LOCATION5423901 MAKE_SQLSTATE('M', '0', '0', 'D', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION5423902 MAKE_SQLSTATE('M', '0', '0', 'D', 'E')

#define ERRCODE_DOCUMENTDB_LOCATION5490710 MAKE_SQLSTATE('M', '0', '0', 'D', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION5624900 MAKE_SQLSTATE('M', '0', '0', 'D', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION5624901 MAKE_SQLSTATE('M', '0', '0', 'D', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION6050202 MAKE_SQLSTATE('M', '0', '0', 'D', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION6050204 MAKE_SQLSTATE('M', '0', '0', 'D', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION5788604 MAKE_SQLSTATE('M', '0', '0', 'D', 'K')

#define ERRCODE_DOCUMENTDB_LOCATION31170 MAKE_SQLSTATE('M', '0', '0', 'D', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION31465 MAKE_SQLSTATE('M', '0', '0', 'D', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION40181 MAKE_SQLSTATE('M', '0', '0', 'D', 'N')

#define ERRCODE_DOCUMENTDB_INVALIDLENGTH MAKE_SQLSTATE('M', '0', '0', 'D', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION15998 MAKE_SQLSTATE('M', '0', '0', 'D', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION40229 MAKE_SQLSTATE('M', '0', '0', 'D', 'Q')

#define ERRCODE_DOCUMENTDB_USERCOUNTLIMITEXCEEDED \
	MAKE_SQLSTATE('M', '0', '0', 'D', 'R')

#define ERRCODE_DOCUMENTDB_LOCATION55 MAKE_SQLSTATE('M', '0', '0', 'D', 'S')

#define ERRCODE_DOCUMENTDB_LOCATION40236 MAKE_SQLSTATE('M', '0', '0', 'D', 'T')

#define ERRCODE_DOCUMENTDB_LOCATION17053 MAKE_SQLSTATE('M', '0', '0', 'D', 'U')

#define ERRCODE_DOCUMENTDB_LOCATION7429703 MAKE_SQLSTATE('M', '0', '0', 'D', 'V')

#define ERRCODE_DOCUMENTDB_LOCATION7436100 MAKE_SQLSTATE('M', '0', '0', 'D', 'W')

#define ERRCODE_DOCUMENTDB_LOCATION7750301 MAKE_SQLSTATE('M', '0', '0', 'D', 'X')

#define ERRCODE_DOCUMENTDB_LOCATION7750302 MAKE_SQLSTATE('M', '0', '0', 'D', 'Y')

#define ERRCODE_DOCUMENTDB_LOCATION7750303 MAKE_SQLSTATE('M', '0', '0', 'D', 'Z')

#define ERRCODE_DOCUMENTDB_LOCATION51003 MAKE_SQLSTATE('M', '0', '0', 'E', '0')

#define ERRCODE_DOCUMENTDB_LOCATION7749501 MAKE_SQLSTATE('M', '0', '0', 'E', '1')

#define ERRCODE_DOCUMENTDB_LOCATION5860402 MAKE_SQLSTATE('M', '0', '0', 'E', '2')

#define ERRCODE_DOCUMENTDB_LOCATION7555701 MAKE_SQLSTATE('M', '0', '0', 'E', '3')

#define ERRCODE_DOCUMENTDB_LOCATION7555702 MAKE_SQLSTATE('M', '0', '0', 'E', '4')

#define ERRCODE_DOCUMENTDB_LOCATION3041704 MAKE_SQLSTATE('M', '0', '0', 'E', '5')

#define ERRCODE_DOCUMENTDB_LOCATION4341107 MAKE_SQLSTATE('M', '0', '0', 'E', '6')

#define ERRCODE_DOCUMENTDB_INSUFFICIENTPRIVILEGE MAKE_SQLSTATE('M', '0', '0', 'E', '7')

#define ERRCODE_DOCUMENTDB_NOTWRITABLEPRIMARY MAKE_SQLSTATE('M', '0', '0', 'E', '8')

#define ERRCODE_DOCUMENTDB_LOCATION40239 MAKE_SQLSTATE('M', '0', '0', 'E', '9')

#define ERRCODE_DOCUMENTDB_LOCATION40240 MAKE_SQLSTATE('M', '0', '0', 'E', 'A')

#define ERRCODE_DOCUMENTDB_LOCATION40241 MAKE_SQLSTATE('M', '0', '0', 'E', 'B')

#define ERRCODE_DOCUMENTDB_LOCATION40242 MAKE_SQLSTATE('M', '0', '0', 'E', 'C')

#define ERRCODE_DOCUMENTDB_LOCATION40243 MAKE_SQLSTATE('M', '0', '0', 'E', 'D')

#define ERRCODE_DOCUMENTDB_LOCATION40244 MAKE_SQLSTATE('M', '0', '0', 'E', 'E')

#define ERRCODE_DOCUMENTDB_LOCATION40245 MAKE_SQLSTATE('M', '0', '0', 'E', 'F')

#define ERRCODE_DOCUMENTDB_LOCATION40246 MAKE_SQLSTATE('M', '0', '0', 'E', 'G')

#define ERRCODE_DOCUMENTDB_LOCATION40257 MAKE_SQLSTATE('M', '0', '0', 'E', 'H')

#define ERRCODE_DOCUMENTDB_LOCATION40258 MAKE_SQLSTATE('M', '0', '0', 'E', 'I')

#define ERRCODE_DOCUMENTDB_LOCATION40260 MAKE_SQLSTATE('M', '0', '0', 'E', 'J')

#define ERRCODE_DOCUMENTDB_LOCATION40261 MAKE_SQLSTATE('M', '0', '0', 'E', 'K')

#define ERRCODE_DOCUMENTDB_CURSORINUSE MAKE_SQLSTATE('M', '0', '0', 'E', 'L')

#define ERRCODE_DOCUMENTDB_LOCATION13103 MAKE_SQLSTATE('M', '0', '0', 'E', 'M')

#define ERRCODE_DOCUMENTDB_LOCATION17385 MAKE_SQLSTATE('M', '0', '0', 'E', 'N')

#define ERRCODE_DOCUMENTDB_LOCATION31319 MAKE_SQLSTATE('M', '0', '0', 'E', 'O')

#define ERRCODE_DOCUMENTDB_LOCATION31320 MAKE_SQLSTATE('M', '0', '0', 'E', 'P')

#define ERRCODE_DOCUMENTDB_LOCATION31321 MAKE_SQLSTATE('M', '0', '0', 'E', 'Q')

#endif
