"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.visibleGlyphsFromUnicodeSet = exports.traceGlyphs = void 0;
const glyphs_1 = require("./glyphs");
const gsub_gpos_1 = require("./gsub-gpos");
const math_1 = require("./math");
function traceGlyphsImpl(font, tracer) {
    const gOrd = font.glyphs.decideOrder();
    for (const g of gOrd)
        (0, glyphs_1.traceGlyphDependents)(g)(tracer);
    if (font.gsub)
        (0, gsub_gpos_1.traceGsub)(font.gsub)(tracer);
    if (font.gpos)
        (0, gsub_gpos_1.traceGpos)(font.gpos)(tracer);
    if (font.math)
        (0, math_1.traceMath)(font.math)(tracer);
}
function traceGlyphs(tracer, font) {
    let sizeBefore = 0, sizeAfter = 0;
    do {
        sizeBefore = tracer.size;
        traceGlyphsImpl(font, tracer);
        sizeAfter = tracer.size;
    } while (sizeBefore < sizeAfter);
    return tracer;
}
exports.traceGlyphs = traceGlyphs;
function visibleGlyphsFromUnicodeSet(font, unicodeSet) {
    const gOrd = font.glyphs.decideOrder();
    const init = new Set();
    init.add(gOrd.at(0)); // keep NOTDEF
    if (font.cmap) {
        for (const [u, glyph] of font.cmap.unicode.entries()) {
            if (unicodeSet.has(u))
                init.add(glyph);
        }
        for (const [u, s, glyph] of font.cmap.vs.entries()) {
            if (unicodeSet.has(u))
                init.add(glyph);
            if (unicodeSet.has(s))
                init.add(glyph);
        }
    }
    return init;
}
exports.visibleGlyphsFromUnicodeSet = visibleGlyphsFromUnicodeSet;
//# sourceMappingURL=index.js.map