import { Maybe } from "./maybe";
export interface OrderStoreFactory<T, S extends OrderStore<T> = OrderStore<T>> {
    createStoreFromList(init: Iterable<T>): S;
}
export interface OrderStoreFactoryWithDefault<T, S extends OrderStore<T> = OrderStore<T>> extends OrderStoreFactory<T, S> {
    createStoreFromSize(count: number): S;
}
export interface OrderStore<T> {
    decideOrder(): Order<T>;
}
export interface Order<T> {
    readonly length: number;
    modIndex(ix: number): number;
    at(index: number): T;
    tryAt(index: number): Maybe<T>;
    reverse(item: T): number;
    tryReverse(item: T): Maybe<number>;
    tryReverseFallback<F>(item: Maybe<T>, fallback: F): number | F;
    [Symbol.iterator](): IterableIterator<T>;
    entries(): IterableIterator<[number, T]>;
}
//# sourceMappingURL=order-store.d.ts.map