"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rectifyGdefTable = rectifyGdefTable;
const ImpLib = require("@ot-builder/common-impl");
const Ot = require("@ot-builder/ot");
const interface_1 = require("../../interface");
const shared_1 = require("../../shared");
function rectifyGdefTable(recGlyphRef, recCoord, recPA, gdef) {
    const newTable = new Ot.Gdef.Table();
    if (gdef.glyphClassDef) {
        newTable.glyphClassDef = shared_1.RectifyImpl.Glyph.mapSome(recGlyphRef, gdef.glyphClassDef);
    }
    if (gdef.attachList) {
        newTable.attachList = shared_1.RectifyImpl.Glyph.mapSome(recGlyphRef, gdef.attachList);
    }
    if (gdef.markAttachClassDef) {
        newTable.markAttachClassDef = shared_1.RectifyImpl.Glyph.mapSome(recGlyphRef, gdef.markAttachClassDef);
    }
    if (gdef.markGlyphSets) {
        newTable.markGlyphSets = shared_1.RectifyImpl.listSomeT(recGlyphRef, gdef.markGlyphSets, shared_1.RectifyImpl.Glyph.setSome);
    }
    if (gdef.ligCarets) {
        newTable.ligCarets = new ImpLib.FunctionHelper.Chain(gdef.ligCarets)
            .apply(_ => shared_1.RectifyImpl.Glyph.mapSome(recGlyphRef, _))
            .apply(_ => shared_1.RectifyImpl.mapSomeT(recCoord, _, shared_1.RectifyImpl.Id, ligCaretArrayCoord))
            .apply(_ => shared_1.RectifyImpl.mapSomeT2(recPA, _, shared_1.RectifyImpl.Id, ligCaretArrayPA)).result;
    }
    return newTable;
}
function ligCaretArrayCoord(r, lcs) {
    return shared_1.RectifyImpl.listSomeT(r, lcs, ligCaretCoord);
}
function ligCaretCoord(rec, lc) {
    return { ...lc, x: rec.coord(lc.x) };
}
function ligCaretArrayPA(rec, g, lcs) {
    return shared_1.RectifyImpl.listSomeT(rec, lcs, (rec, lc) => ligCaretPointAttachment(rec, g, lc));
}
function ligCaretPointAttachment(rectifier, context, lc) {
    if (!lc.pointAttachment)
        return lc;
    const desired = shared_1.RectifyImpl.getGlyphPoints(context)[lc.pointAttachment.pointIndex];
    if (!desired)
        return { ...lc, pointAttachment: null };
    const accept = rectifier.acceptOffset(desired, { x: lc.x, y: desired.y });
    if (accept.x)
        return lc;
    switch (rectifier.manner) {
        case interface_1.PointAttachmentRectifyManner.TrustAttachment:
            return { ...lc, x: desired.x };
        case interface_1.PointAttachmentRectifyManner.TrustCoordinate:
            return { ...lc, pointAttachment: null };
    }
}
//# sourceMappingURL=index.js.map