// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/sql/v1beta4/cloud_sql.proto

package sql

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode int32

const (
	// Unknown external sync mode, will be defaulted to ONLINE mode
	SqlInstancesVerifyExternalSyncSettingsRequest_EXTERNAL_SYNC_MODE_UNSPECIFIED SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode = 0
	// Online external sync will set up replication after initial data external
	// sync
	SqlInstancesVerifyExternalSyncSettingsRequest_ONLINE SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode = 1
	// Offline external sync only dumps and loads a one-time snapshot of
	// the primary instance's data
	SqlInstancesVerifyExternalSyncSettingsRequest_OFFLINE SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode = 2
)

// Enum value maps for SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode.
var (
	SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode_name = map[int32]string{
		0: "EXTERNAL_SYNC_MODE_UNSPECIFIED",
		1: "ONLINE",
		2: "OFFLINE",
	}
	SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode_value = map[string]int32{
		"EXTERNAL_SYNC_MODE_UNSPECIFIED": 0,
		"ONLINE":                         1,
		"OFFLINE":                        2,
	}
)

func (x SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) Enum() *SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode {
	p := new(SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode)
	*p = x
	return p
}

func (x SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_enumTypes[0].Descriptor()
}

func (SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_proto_enumTypes[0]
}

func (x SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode.Descriptor instead.
func (SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{32, 0}
}

type SqlBackupRunsDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the backup run to delete. To find a backup run ID, use the
	// [list](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1beta4/backupRuns/list)
	// method.
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlBackupRunsDeleteRequest) Reset() {
	*x = SqlBackupRunsDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlBackupRunsDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlBackupRunsDeleteRequest) ProtoMessage() {}

func (x *SqlBackupRunsDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlBackupRunsDeleteRequest.ProtoReflect.Descriptor instead.
func (*SqlBackupRunsDeleteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{0}
}

func (x *SqlBackupRunsDeleteRequest) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *SqlBackupRunsDeleteRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlBackupRunsDeleteRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlBackupRunsGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of this backup run.
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlBackupRunsGetRequest) Reset() {
	*x = SqlBackupRunsGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlBackupRunsGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlBackupRunsGetRequest) ProtoMessage() {}

func (x *SqlBackupRunsGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlBackupRunsGetRequest.ProtoReflect.Descriptor instead.
func (*SqlBackupRunsGetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{1}
}

func (x *SqlBackupRunsGetRequest) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *SqlBackupRunsGetRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlBackupRunsGetRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlBackupRunsInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string     `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *BackupRun `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlBackupRunsInsertRequest) Reset() {
	*x = SqlBackupRunsInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlBackupRunsInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlBackupRunsInsertRequest) ProtoMessage() {}

func (x *SqlBackupRunsInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlBackupRunsInsertRequest.ProtoReflect.Descriptor instead.
func (*SqlBackupRunsInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{2}
}

func (x *SqlBackupRunsInsertRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlBackupRunsInsertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlBackupRunsInsertRequest) GetBody() *BackupRun {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlBackupRunsListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID, or "-" for all instances. This does not include
	// the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Maximum number of backup runs per response.
	MaxResults int32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlBackupRunsListRequest) Reset() {
	*x = SqlBackupRunsListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlBackupRunsListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlBackupRunsListRequest) ProtoMessage() {}

func (x *SqlBackupRunsListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlBackupRunsListRequest.ProtoReflect.Descriptor instead.
func (*SqlBackupRunsListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{3}
}

func (x *SqlBackupRunsListRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlBackupRunsListRequest) GetMaxResults() int32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *SqlBackupRunsListRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SqlBackupRunsListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlDatabasesDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the database to be deleted in the instance.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlDatabasesDeleteRequest) Reset() {
	*x = SqlDatabasesDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlDatabasesDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlDatabasesDeleteRequest) ProtoMessage() {}

func (x *SqlDatabasesDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlDatabasesDeleteRequest.ProtoReflect.Descriptor instead.
func (*SqlDatabasesDeleteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{4}
}

func (x *SqlDatabasesDeleteRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *SqlDatabasesDeleteRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlDatabasesDeleteRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlDatabasesGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the database in the instance.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlDatabasesGetRequest) Reset() {
	*x = SqlDatabasesGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlDatabasesGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlDatabasesGetRequest) ProtoMessage() {}

func (x *SqlDatabasesGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlDatabasesGetRequest.ProtoReflect.Descriptor instead.
func (*SqlDatabasesGetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{5}
}

func (x *SqlDatabasesGetRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *SqlDatabasesGetRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlDatabasesGetRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlDatabasesInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string    `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *Database `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlDatabasesInsertRequest) Reset() {
	*x = SqlDatabasesInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlDatabasesInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlDatabasesInsertRequest) ProtoMessage() {}

func (x *SqlDatabasesInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlDatabasesInsertRequest.ProtoReflect.Descriptor instead.
func (*SqlDatabasesInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{6}
}

func (x *SqlDatabasesInsertRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlDatabasesInsertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlDatabasesInsertRequest) GetBody() *Database {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlDatabasesListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlDatabasesListRequest) Reset() {
	*x = SqlDatabasesListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlDatabasesListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlDatabasesListRequest) ProtoMessage() {}

func (x *SqlDatabasesListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlDatabasesListRequest.ProtoReflect.Descriptor instead.
func (*SqlDatabasesListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{7}
}

func (x *SqlDatabasesListRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlDatabasesListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlDatabasesUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the database to be updated in the instance.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string    `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
	Body    *Database `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlDatabasesUpdateRequest) Reset() {
	*x = SqlDatabasesUpdateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlDatabasesUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlDatabasesUpdateRequest) ProtoMessage() {}

func (x *SqlDatabasesUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlDatabasesUpdateRequest.ProtoReflect.Descriptor instead.
func (*SqlDatabasesUpdateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{8}
}

func (x *SqlDatabasesUpdateRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *SqlDatabasesUpdateRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlDatabasesUpdateRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlDatabasesUpdateRequest) GetBody() *Database {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlFlagsListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database type and version you want to retrieve flags for. By default, this
	// method returns flags for all database types and versions.
	DatabaseVersion string `protobuf:"bytes,1,opt,name=database_version,json=databaseVersion,proto3" json:"database_version,omitempty"`
}

func (x *SqlFlagsListRequest) Reset() {
	*x = SqlFlagsListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlFlagsListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlFlagsListRequest) ProtoMessage() {}

func (x *SqlFlagsListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlFlagsListRequest.ProtoReflect.Descriptor instead.
func (*SqlFlagsListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{9}
}

func (x *SqlFlagsListRequest) GetDatabaseVersion() string {
	if x != nil {
		return x.DatabaseVersion
	}
	return ""
}

type SqlInstancesAddServerCaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesAddServerCaRequest) Reset() {
	*x = SqlInstancesAddServerCaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesAddServerCaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesAddServerCaRequest) ProtoMessage() {}

func (x *SqlInstancesAddServerCaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesAddServerCaRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesAddServerCaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{10}
}

func (x *SqlInstancesAddServerCaRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesAddServerCaRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesCloneRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Cloud SQL instance to be cloned (source). This does not
	// include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the source as well as the clone Cloud SQL instance.
	Project string                 `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesCloneRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesCloneRequest) Reset() {
	*x = SqlInstancesCloneRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesCloneRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesCloneRequest) ProtoMessage() {}

func (x *SqlInstancesCloneRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesCloneRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesCloneRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{11}
}

func (x *SqlInstancesCloneRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesCloneRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesCloneRequest) GetBody() *InstancesCloneRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance to be deleted.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesDeleteRequest) Reset() {
	*x = SqlInstancesDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesDeleteRequest) ProtoMessage() {}

func (x *SqlInstancesDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesDeleteRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesDeleteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{12}
}

func (x *SqlInstancesDeleteRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesDeleteRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesDemoteMasterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance name.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the instance.
	Project string                        `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesDemoteMasterRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesDemoteMasterRequest) Reset() {
	*x = SqlInstancesDemoteMasterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesDemoteMasterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesDemoteMasterRequest) ProtoMessage() {}

func (x *SqlInstancesDemoteMasterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesDemoteMasterRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesDemoteMasterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{13}
}

func (x *SqlInstancesDemoteMasterRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesDemoteMasterRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesDemoteMasterRequest) GetBody() *InstancesDemoteMasterRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance to be exported.
	Project string                  `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesExportRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesExportRequest) Reset() {
	*x = SqlInstancesExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesExportRequest) ProtoMessage() {}

func (x *SqlInstancesExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesExportRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{14}
}

func (x *SqlInstancesExportRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesExportRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesExportRequest) GetBody() *InstancesExportRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesFailoverRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the read replica.
	Project string                    `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesFailoverRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesFailoverRequest) Reset() {
	*x = SqlInstancesFailoverRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesFailoverRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesFailoverRequest) ProtoMessage() {}

func (x *SqlInstancesFailoverRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesFailoverRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesFailoverRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{15}
}

func (x *SqlInstancesFailoverRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesFailoverRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesFailoverRequest) GetBody() *InstancesFailoverRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesGetRequest) Reset() {
	*x = SqlInstancesGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesGetRequest) ProtoMessage() {}

func (x *SqlInstancesGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesGetRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesGetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{16}
}

func (x *SqlInstancesGetRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesGetRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string                  `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesImportRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesImportRequest) Reset() {
	*x = SqlInstancesImportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesImportRequest) ProtoMessage() {}

func (x *SqlInstancesImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesImportRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesImportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{17}
}

func (x *SqlInstancesImportRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesImportRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesImportRequest) GetBody() *InstancesImportRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project ID of the project to which the newly created Cloud SQL instances
	// should belong.
	Project string            `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	Body    *DatabaseInstance `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesInsertRequest) Reset() {
	*x = SqlInstancesInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesInsertRequest) ProtoMessage() {}

func (x *SqlInstancesInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesInsertRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{18}
}

func (x *SqlInstancesInsertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesInsertRequest) GetBody() *DatabaseInstance {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response.
	// The expression is in the form of field:value. For example,
	// 'instanceType:CLOUD_SQL_INSTANCE'. Fields can be nested as needed as per
	// their JSON representation, such as 'settings.userLabels.auto_start:true'.
	//
	// Multiple filter queries are space-separated. For example.
	// 'state:RUNNABLE instanceType:CLOUD_SQL_INSTANCE'. By default, each
	// expression is an AND expression. However, you can include AND and OR
	// expressions explicitly.
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of results to return per response.
	MaxResults uint32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Project ID of the project for which to list Cloud SQL instances.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesListRequest) Reset() {
	*x = SqlInstancesListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesListRequest) ProtoMessage() {}

func (x *SqlInstancesListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesListRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{19}
}

func (x *SqlInstancesListRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *SqlInstancesListRequest) GetMaxResults() uint32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *SqlInstancesListRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SqlInstancesListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesListServerCasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesListServerCasRequest) Reset() {
	*x = SqlInstancesListServerCasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesListServerCasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesListServerCasRequest) ProtoMessage() {}

func (x *SqlInstancesListServerCasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesListServerCasRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesListServerCasRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{20}
}

func (x *SqlInstancesListServerCasRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesListServerCasRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesPatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string            `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *DatabaseInstance `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesPatchRequest) Reset() {
	*x = SqlInstancesPatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesPatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesPatchRequest) ProtoMessage() {}

func (x *SqlInstancesPatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesPatchRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesPatchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{21}
}

func (x *SqlInstancesPatchRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesPatchRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesPatchRequest) GetBody() *DatabaseInstance {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesPromoteReplicaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL read replica instance name.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the read replica.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesPromoteReplicaRequest) Reset() {
	*x = SqlInstancesPromoteReplicaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesPromoteReplicaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesPromoteReplicaRequest) ProtoMessage() {}

func (x *SqlInstancesPromoteReplicaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesPromoteReplicaRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesPromoteReplicaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{22}
}

func (x *SqlInstancesPromoteReplicaRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesPromoteReplicaRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesResetSslConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesResetSslConfigRequest) Reset() {
	*x = SqlInstancesResetSslConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesResetSslConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesResetSslConfigRequest) ProtoMessage() {}

func (x *SqlInstancesResetSslConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesResetSslConfigRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesResetSslConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{23}
}

func (x *SqlInstancesResetSslConfigRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesResetSslConfigRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesRestartRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance to be restarted.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesRestartRequest) Reset() {
	*x = SqlInstancesRestartRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRestartRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRestartRequest) ProtoMessage() {}

func (x *SqlInstancesRestartRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRestartRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesRestartRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{24}
}

func (x *SqlInstancesRestartRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesRestartRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesRestoreBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string                         `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesRestoreBackupRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesRestoreBackupRequest) Reset() {
	*x = SqlInstancesRestoreBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRestoreBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRestoreBackupRequest) ProtoMessage() {}

func (x *SqlInstancesRestoreBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRestoreBackupRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesRestoreBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{25}
}

func (x *SqlInstancesRestoreBackupRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesRestoreBackupRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesRestoreBackupRequest) GetBody() *InstancesRestoreBackupRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesRotateServerCaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string                          `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesRotateServerCaRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesRotateServerCaRequest) Reset() {
	*x = SqlInstancesRotateServerCaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRotateServerCaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRotateServerCaRequest) ProtoMessage() {}

func (x *SqlInstancesRotateServerCaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRotateServerCaRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesRotateServerCaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{26}
}

func (x *SqlInstancesRotateServerCaRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesRotateServerCaRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesRotateServerCaRequest) GetBody() *InstancesRotateServerCaRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesStartReplicaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL read replica instance name.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the read replica.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesStartReplicaRequest) Reset() {
	*x = SqlInstancesStartReplicaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesStartReplicaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesStartReplicaRequest) ProtoMessage() {}

func (x *SqlInstancesStartReplicaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesStartReplicaRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesStartReplicaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{27}
}

func (x *SqlInstancesStartReplicaRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesStartReplicaRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesStopReplicaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL read replica instance name.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the read replica.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlInstancesStopReplicaRequest) Reset() {
	*x = SqlInstancesStopReplicaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesStopReplicaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesStopReplicaRequest) ProtoMessage() {}

func (x *SqlInstancesStopReplicaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesStopReplicaRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesStopReplicaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{28}
}

func (x *SqlInstancesStopReplicaRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesStopReplicaRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesTruncateLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the Cloud SQL project.
	Project string                       `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *InstancesTruncateLogRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesTruncateLogRequest) Reset() {
	*x = SqlInstancesTruncateLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesTruncateLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesTruncateLogRequest) ProtoMessage() {}

func (x *SqlInstancesTruncateLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesTruncateLogRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesTruncateLogRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{29}
}

func (x *SqlInstancesTruncateLogRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesTruncateLogRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesTruncateLogRequest) GetBody() *InstancesTruncateLogRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string            `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *DatabaseInstance `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesUpdateRequest) Reset() {
	*x = SqlInstancesUpdateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesUpdateRequest) ProtoMessage() {}

func (x *SqlInstancesUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesUpdateRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesUpdateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{30}
}

func (x *SqlInstancesUpdateRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesUpdateRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesUpdateRequest) GetBody() *DatabaseInstance {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesRescheduleMaintenanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the instance.
	Project string                                        `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *SqlInstancesRescheduleMaintenanceRequestBody `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesRescheduleMaintenanceRequest) Reset() {
	*x = SqlInstancesRescheduleMaintenanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRescheduleMaintenanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRescheduleMaintenanceRequest) ProtoMessage() {}

func (x *SqlInstancesRescheduleMaintenanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRescheduleMaintenanceRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesRescheduleMaintenanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{31}
}

func (x *SqlInstancesRescheduleMaintenanceRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesRescheduleMaintenanceRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesRescheduleMaintenanceRequest) GetBody() *SqlInstancesRescheduleMaintenanceRequestBody {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlInstancesVerifyExternalSyncSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Flag to enable verifying connection only
	VerifyConnectionOnly bool `protobuf:"varint,3,opt,name=verify_connection_only,json=verifyConnectionOnly,proto3" json:"verify_connection_only,omitempty"`
	// External sync mode
	SyncMode SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode `protobuf:"varint,4,opt,name=sync_mode,json=syncMode,proto3,enum=google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode" json:"sync_mode,omitempty"`
	// Optional. Flag to verify settings required by replication setup only
	VerifyReplicationOnly bool `protobuf:"varint,5,opt,name=verify_replication_only,json=verifyReplicationOnly,proto3" json:"verify_replication_only,omitempty"`
	// Types that are assignable to SyncConfig:
	//	*SqlInstancesVerifyExternalSyncSettingsRequest_MysqlSyncConfig
	SyncConfig isSqlInstancesVerifyExternalSyncSettingsRequest_SyncConfig `protobuf_oneof:"sync_config"`
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) Reset() {
	*x = SqlInstancesVerifyExternalSyncSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesVerifyExternalSyncSettingsRequest) ProtoMessage() {}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesVerifyExternalSyncSettingsRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesVerifyExternalSyncSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{32}
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetVerifyConnectionOnly() bool {
	if x != nil {
		return x.VerifyConnectionOnly
	}
	return false
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetSyncMode() SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode {
	if x != nil {
		return x.SyncMode
	}
	return SqlInstancesVerifyExternalSyncSettingsRequest_EXTERNAL_SYNC_MODE_UNSPECIFIED
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetVerifyReplicationOnly() bool {
	if x != nil {
		return x.VerifyReplicationOnly
	}
	return false
}

func (m *SqlInstancesVerifyExternalSyncSettingsRequest) GetSyncConfig() isSqlInstancesVerifyExternalSyncSettingsRequest_SyncConfig {
	if m != nil {
		return m.SyncConfig
	}
	return nil
}

func (x *SqlInstancesVerifyExternalSyncSettingsRequest) GetMysqlSyncConfig() *MySqlSyncConfig {
	if x, ok := x.GetSyncConfig().(*SqlInstancesVerifyExternalSyncSettingsRequest_MysqlSyncConfig); ok {
		return x.MysqlSyncConfig
	}
	return nil
}

type isSqlInstancesVerifyExternalSyncSettingsRequest_SyncConfig interface {
	isSqlInstancesVerifyExternalSyncSettingsRequest_SyncConfig()
}

type SqlInstancesVerifyExternalSyncSettingsRequest_MysqlSyncConfig struct {
	// Optional. MySQL-specific settings for start external sync.
	MysqlSyncConfig *MySqlSyncConfig `protobuf:"bytes,6,opt,name=mysql_sync_config,json=mysqlSyncConfig,proto3,oneof"`
}

func (*SqlInstancesVerifyExternalSyncSettingsRequest_MysqlSyncConfig) isSqlInstancesVerifyExternalSyncSettingsRequest_SyncConfig() {
}

type SqlInstancesStartExternalSyncRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// External sync mode.
	SyncMode SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode `protobuf:"varint,3,opt,name=sync_mode,json=syncMode,proto3,enum=google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode" json:"sync_mode,omitempty"`
	// Whether to skip the verification step (VESS).
	SkipVerification bool `protobuf:"varint,4,opt,name=skip_verification,json=skipVerification,proto3" json:"skip_verification,omitempty"`
	// Types that are assignable to SyncConfig:
	//	*SqlInstancesStartExternalSyncRequest_MysqlSyncConfig
	SyncConfig isSqlInstancesStartExternalSyncRequest_SyncConfig `protobuf_oneof:"sync_config"`
}

func (x *SqlInstancesStartExternalSyncRequest) Reset() {
	*x = SqlInstancesStartExternalSyncRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesStartExternalSyncRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesStartExternalSyncRequest) ProtoMessage() {}

func (x *SqlInstancesStartExternalSyncRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesStartExternalSyncRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesStartExternalSyncRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{33}
}

func (x *SqlInstancesStartExternalSyncRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesStartExternalSyncRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesStartExternalSyncRequest) GetSyncMode() SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode {
	if x != nil {
		return x.SyncMode
	}
	return SqlInstancesVerifyExternalSyncSettingsRequest_EXTERNAL_SYNC_MODE_UNSPECIFIED
}

func (x *SqlInstancesStartExternalSyncRequest) GetSkipVerification() bool {
	if x != nil {
		return x.SkipVerification
	}
	return false
}

func (m *SqlInstancesStartExternalSyncRequest) GetSyncConfig() isSqlInstancesStartExternalSyncRequest_SyncConfig {
	if m != nil {
		return m.SyncConfig
	}
	return nil
}

func (x *SqlInstancesStartExternalSyncRequest) GetMysqlSyncConfig() *MySqlSyncConfig {
	if x, ok := x.GetSyncConfig().(*SqlInstancesStartExternalSyncRequest_MysqlSyncConfig); ok {
		return x.MysqlSyncConfig
	}
	return nil
}

type isSqlInstancesStartExternalSyncRequest_SyncConfig interface {
	isSqlInstancesStartExternalSyncRequest_SyncConfig()
}

type SqlInstancesStartExternalSyncRequest_MysqlSyncConfig struct {
	// MySQL-specific settings for start external sync.
	MysqlSyncConfig *MySqlSyncConfig `protobuf:"bytes,6,opt,name=mysql_sync_config,json=mysqlSyncConfig,proto3,oneof"`
}

func (*SqlInstancesStartExternalSyncRequest_MysqlSyncConfig) isSqlInstancesStartExternalSyncRequest_SyncConfig() {
}

type SqlOperationsGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instance operation ID.
	Operation string `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlOperationsGetRequest) Reset() {
	*x = SqlOperationsGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlOperationsGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlOperationsGetRequest) ProtoMessage() {}

func (x *SqlOperationsGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlOperationsGetRequest.ProtoReflect.Descriptor instead.
func (*SqlOperationsGetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{34}
}

func (x *SqlOperationsGetRequest) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *SqlOperationsGetRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlOperationsListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Maximum number of operations per response.
	MaxResults uint32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlOperationsListRequest) Reset() {
	*x = SqlOperationsListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlOperationsListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlOperationsListRequest) ProtoMessage() {}

func (x *SqlOperationsListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlOperationsListRequest.ProtoReflect.Descriptor instead.
func (*SqlOperationsListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{35}
}

func (x *SqlOperationsListRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlOperationsListRequest) GetMaxResults() uint32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *SqlOperationsListRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SqlOperationsListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

type SqlInstancesCreateEphemeralCertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the Cloud SQL project.
	Project string                          `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *SslCertsCreateEphemeralRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlInstancesCreateEphemeralCertRequest) Reset() {
	*x = SqlInstancesCreateEphemeralCertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesCreateEphemeralCertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesCreateEphemeralCertRequest) ProtoMessage() {}

func (x *SqlInstancesCreateEphemeralCertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesCreateEphemeralCertRequest.ProtoReflect.Descriptor instead.
func (*SqlInstancesCreateEphemeralCertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{36}
}

func (x *SqlInstancesCreateEphemeralCertRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlInstancesCreateEphemeralCertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlInstancesCreateEphemeralCertRequest) GetBody() *SslCertsCreateEphemeralRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlSslCertsDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Sha1 FingerPrint.
	Sha1Fingerprint string `protobuf:"bytes,3,opt,name=sha1_fingerprint,json=sha1Fingerprint,proto3" json:"sha1_fingerprint,omitempty"`
}

func (x *SqlSslCertsDeleteRequest) Reset() {
	*x = SqlSslCertsDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlSslCertsDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlSslCertsDeleteRequest) ProtoMessage() {}

func (x *SqlSslCertsDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlSslCertsDeleteRequest.ProtoReflect.Descriptor instead.
func (*SqlSslCertsDeleteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{37}
}

func (x *SqlSslCertsDeleteRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlSslCertsDeleteRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlSslCertsDeleteRequest) GetSha1Fingerprint() string {
	if x != nil {
		return x.Sha1Fingerprint
	}
	return ""
}

type SqlSslCertsGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Sha1 FingerPrint.
	Sha1Fingerprint string `protobuf:"bytes,3,opt,name=sha1_fingerprint,json=sha1Fingerprint,proto3" json:"sha1_fingerprint,omitempty"`
}

func (x *SqlSslCertsGetRequest) Reset() {
	*x = SqlSslCertsGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlSslCertsGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlSslCertsGetRequest) ProtoMessage() {}

func (x *SqlSslCertsGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlSslCertsGetRequest.ProtoReflect.Descriptor instead.
func (*SqlSslCertsGetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{38}
}

func (x *SqlSslCertsGetRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlSslCertsGetRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlSslCertsGetRequest) GetSha1Fingerprint() string {
	if x != nil {
		return x.Sha1Fingerprint
	}
	return ""
}

type SqlSslCertsInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string                 `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *SslCertsInsertRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlSslCertsInsertRequest) Reset() {
	*x = SqlSslCertsInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlSslCertsInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlSslCertsInsertRequest) ProtoMessage() {}

func (x *SqlSslCertsInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlSslCertsInsertRequest.ProtoReflect.Descriptor instead.
func (*SqlSslCertsInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{39}
}

func (x *SqlSslCertsInsertRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlSslCertsInsertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlSslCertsInsertRequest) GetBody() *SslCertsInsertRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlSslCertsListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlSslCertsListRequest) Reset() {
	*x = SqlSslCertsListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlSslCertsListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlSslCertsListRequest) ProtoMessage() {}

func (x *SqlSslCertsListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlSslCertsListRequest.ProtoReflect.Descriptor instead.
func (*SqlSslCertsListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP(), []int{40}
}

func (x *SqlSslCertsListRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlSslCertsListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

var File_google_cloud_sql_v1beta4_cloud_sql_proto protoreflect.FileDescriptor

var file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x73, 0x71, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x62, 0x0a, 0x1a, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e,
	0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1a,
	0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x22, 0x5f, 0x0a, 0x17, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x52, 0x75, 0x6e, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x8b, 0x01, 0x0a, 0x1a, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x37, 0x0a, 0x04, 0x62, 0x6f,
	0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x22, 0x90, 0x01, 0x0a, 0x18, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x52, 0x75, 0x6e, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x6d, 0x0a, 0x19, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x6a, 0x0a, 0x16, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x22, 0x89, 0x01, 0x0a, 0x19, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x4f, 0x0a,
	0x17, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xa5,
	0x01, 0x0a, 0x19, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x36,
	0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x40, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x46, 0x6c, 0x61,
	0x67, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a,
	0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x56, 0x0a, 0x1e, 0x53, 0x71, 0x6c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x41, 0x64, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x22, 0x95, 0x01, 0x0a, 0x18, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x51, 0x0a, 0x19, 0x53, 0x71, 0x6c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xa3, 0x01, 0x0a, 0x1f,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x44, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64,
	0x79, 0x22, 0x97, 0x01, 0x0a, 0x19, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x9b, 0x01, 0x0a, 0x1b,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x46, 0x61, 0x69, 0x6c,
	0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x46, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x4e, 0x0a, 0x16, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x97, 0x01, 0x0a, 0x19, 0x53, 0x71,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x44, 0x0a,
	0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x22, 0x75, 0x0a, 0x19, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x62, 0x6f,
	0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x8b, 0x01, 0x0a, 0x17, 0x53,
	0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f,
	0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x58, 0x0a, 0x20, 0x53, 0x71, 0x6c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x22, 0x90, 0x01, 0x0a, 0x18, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x50, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x59, 0x0a, 0x21, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x22, 0x59, 0x0a, 0x21, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x65, 0x74, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x52, 0x0a, 0x1a, 0x53,
	0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22,
	0xa5, 0x01, 0x0a, 0x20, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x62, 0x6f,
	0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0xa7, 0x01, 0x0a, 0x21, 0x53, 0x71, 0x6c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64,
	0x79, 0x22, 0x57, 0x0a, 0x1f, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x56, 0x0a, 0x1e, 0x53, 0x71,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x22, 0xa1, 0x01, 0x0a, 0x1e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x54, 0x72,
	0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x91, 0x01, 0x0a, 0x19, 0x53, 0x71, 0x6c, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x62, 0x6f,
	0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0xbc, 0x01, 0x0a, 0x28, 0x53,
	0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x5a, 0x0a,
	0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42,
	0x6f, 0x64, 0x79, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x8d, 0x04, 0x0a, 0x2d, 0x53, 0x71,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79,
	0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x34, 0x0a, 0x16, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x14, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x75, 0x0a, 0x09, 0x73, 0x79, 0x6e, 0x63, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x3b,
	0x0a, 0x17, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x5c, 0x0a, 0x11, 0x6d,
	0x79, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x53,
	0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4f, 0x0a, 0x10, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a,
	0x1e, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x59, 0x4e, 0x43, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x4f, 0x46, 0x46, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x73, 0x79,
	0x6e, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xe8, 0x02, 0x0a, 0x24, 0x53, 0x71,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x45,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x75, 0x0a, 0x09, 0x73, 0x79, 0x6e, 0x63,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e,
	0x63, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x2b, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x73, 0x6b, 0x69, 0x70,
	0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x11,
	0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x0d, 0x0a, 0x0b, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x51, 0x0a, 0x17, 0x53, 0x71, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1c, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x90, 0x01, 0x0a, 0x18, 0x53, 0x71, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xac, 0x01, 0x0a, 0x26, 0x53,
	0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x7b, 0x0a, 0x18, 0x53, 0x71, 0x6c,
	0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x73,
	0x68, 0x61, 0x31, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x68, 0x61, 0x31, 0x46, 0x69, 0x6e, 0x67, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0x78, 0x0a, 0x15, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c,
	0x43, 0x65, 0x72, 0x74, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x68, 0x61, 0x31, 0x5f, 0x66, 0x69,
	0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x73, 0x68, 0x61, 0x31, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74,
	0x22, 0x95, 0x01, 0x0a, 0x18, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73,
	0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c,
	0x43, 0x65, 0x72, 0x74, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x4e, 0x0a, 0x16, 0x53, 0x71, 0x6c, 0x53,
	0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x32, 0xe3, 0x06, 0x0a, 0x14, 0x53, 0x71, 0x6c,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xb1, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x52, 0x75, 0x6e, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x2a,
	0x44, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73,
	0x2f, 0x7b, 0x69, 0x64, 0x7d, 0x12, 0xab, 0x01, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x75, 0x6e, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12, 0x44, 0x2f,
	0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x2f, 0x7b,
	0x69, 0x64, 0x7d, 0x12, 0xb2, 0x01, 0x0a, 0x06, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x47, 0x22, 0x3f, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75,
	0x6e, 0x73, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xb5, 0x01, 0x0a, 0x04, 0x4c, 0x69, 0x73,
	0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12,
	0x3f, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73,
	0x1a, 0x7c, 0xca, 0x41, 0x17, 0x73, 0x71, 0x6c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5f, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x71,
	0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x32, 0xdf,
	0x09, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb5, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x51, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4b, 0x2a, 0x49, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x12, 0xae,
	0x01, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x22, 0x51, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x12,
	0xb0, 0x01, 0x0a, 0x06, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x22, 0x3e, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x3a, 0x04, 0x62, 0x6f,
	0x64, 0x79, 0x12, 0xb2, 0x01, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x12, 0x3e, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12, 0xba, 0x01, 0x0a, 0x05, 0x50, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x57, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x51, 0x32, 0x49, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x3a, 0x04,
	0x62, 0x6f, 0x64, 0x79, 0x12, 0xbb, 0x01, 0x0a, 0x06, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x51, 0x1a, 0x49, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x3a, 0x04, 0x62, 0x6f,
	0x64, 0x79, 0x1a, 0x7c, 0xca, 0x41, 0x17, 0x73, 0x71, 0x6c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x32, 0x8f, 0x02, 0x0a, 0x0f, 0x53, 0x71, 0x6c, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x7e, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x14,
	0x12, 0x12, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x66,
	0x6c, 0x61, 0x67, 0x73, 0x1a, 0x7c, 0xca, 0x41, 0x17, 0x73, 0x71, 0x6c, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x32, 0xf2, 0x25, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb6, 0x01, 0x0a, 0x0b, 0x41,
	0x64, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x41, 0x64, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x42, 0x22, 0x40, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x61, 0x64, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x61, 0x12, 0xaa, 0x01, 0x0a, 0x05, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x12, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x3a,
	0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79,
	0x12, 0xa0, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x2a, 0x34, 0x2f,
	0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x7d, 0x12, 0xbf, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x44, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x22, 0x41, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x2f, 0x64, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x3a,
	0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xad, 0x01, 0x0a, 0x06, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x43, 0x22, 0x3b, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a,
	0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xb3, 0x01, 0x0a, 0x08, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76,
	0x65, 0x72, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x3d, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x66, 0x61, 0x69,
	0x6c, 0x6f, 0x76, 0x65, 0x72, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xa1, 0x01, 0x0a, 0x03,
	0x47, 0x65, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53,
	0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x73, 0x71, 0x6c, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x12,
	0xad, 0x01, 0x0a, 0x06, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x22, 0x3b, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12,
	0x9b, 0x01, 0x0a, 0x06, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x22, 0x29, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x9d, 0x01,
	0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2b, 0x12, 0x29, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xd1, 0x01,
	0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x73, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f,
	0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x7d, 0x2f, 0x6c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61,
	0x73, 0x12, 0xa4, 0x01, 0x0a, 0x05, 0x50, 0x61, 0x74, 0x63, 0x68, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x50, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x32, 0x34, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xbf, 0x01, 0x0a, 0x0e, 0x50, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x43, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x6d,
	0x6f, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12, 0xbf, 0x01, 0x0a, 0x0e, 0x52,
	0x65, 0x73, 0x65, 0x74, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x65, 0x74, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x43, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x72, 0x65,
	0x73, 0x65, 0x74, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xaa, 0x01, 0x0a,
	0x07, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x3c, 0x2f, 0x73, 0x71,
	0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0xc2, 0x01, 0x0a, 0x0d, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x50, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4a, 0x22, 0x42, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xc5,
	0x01, 0x0a, 0x0e, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x61, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x22, 0x43, 0x2f, 0x73, 0x71,
	0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x7d, 0x2f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61,
	0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xb9, 0x01, 0x0a, 0x0c, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x22,
	0x41, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x12, 0xb6, 0x01, 0x0a, 0x0b, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71,
	0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x40, 0x2f, 0x73, 0x71, 0x6c, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f,
	0x73, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12, 0xbc, 0x01, 0x0a, 0x0b,
	0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x48, 0x22, 0x40, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74,
	0x65, 0x4c, 0x6f, 0x67, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xa6, 0x01, 0x0a, 0x06, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x1a, 0x34, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x3a, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x12, 0xca, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x70,
	0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x43, 0x65,
	0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x22, 0x52, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4c, 0x22, 0x44, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79,
	0x12, 0xda, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x22, 0x4a, 0x2f, 0x73, 0x71,
	0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x7d, 0x2f, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x8b, 0x02,
	0x0a, 0x1a, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x47, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x56, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x22, 0x4f, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0xcb, 0x01, 0x0a, 0x11,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e,
	0x63, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x45, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x22, 0x46,
	0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x3a, 0x01, 0x2a, 0x1a, 0x7c, 0xca, 0x41, 0x17, 0x73, 0x71,
	0x6c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x32, 0xd7, 0x03, 0x0a, 0x14, 0x53, 0x71, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x9d, 0x01, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x12, 0xa0, 0x01, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0x7c, 0xca, 0x41, 0x17, 0x73, 0x71, 0x6c, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x32, 0xf6, 0x06, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74,
	0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xbb, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53,
	0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x58, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x52, 0x2a, 0x50, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x73, 0x6c, 0x43, 0x65,
	0x72, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x68, 0x61, 0x31, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x7d, 0x12, 0xb3, 0x01, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c,
	0x43, 0x65, 0x72, 0x74, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65,
	0x72, 0x74, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12, 0x50, 0x2f, 0x73, 0x71, 0x6c,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d,
	0x2f, 0x73, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x68, 0x61, 0x31, 0x5f,
	0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x7d, 0x12, 0xbb, 0x01, 0x0a,
	0x06, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x49, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x49,
	0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x3d, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x73, 0x6c, 0x43,
	0x65, 0x72, 0x74, 0x73, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xaf, 0x01, 0x0a, 0x04, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53,
	0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f,
	0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x7d, 0x2f, 0x73, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x1a, 0x7c, 0xca, 0x41,
	0x17, 0x73, 0x71, 0x6c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x42, 0x73, 0x0a, 0x1c, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x42, 0x14, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x3b, 0x73, 0x71, 0x6c, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescOnce sync.Once
	file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescData = file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDesc
)

func file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescGZIP() []byte {
	file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescOnce.Do(func() {
		file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescData)
	})
	return file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDescData
}

var file_google_cloud_sql_v1beta4_cloud_sql_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes = make([]protoimpl.MessageInfo, 41)
var file_google_cloud_sql_v1beta4_cloud_sql_proto_goTypes = []interface{}{
	(SqlInstancesVerifyExternalSyncSettingsRequest_ExternalSyncMode)(0), // 0: google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsRequest.ExternalSyncMode
	(*SqlBackupRunsDeleteRequest)(nil),                                  // 1: google.cloud.sql.v1beta4.SqlBackupRunsDeleteRequest
	(*SqlBackupRunsGetRequest)(nil),                                     // 2: google.cloud.sql.v1beta4.SqlBackupRunsGetRequest
	(*SqlBackupRunsInsertRequest)(nil),                                  // 3: google.cloud.sql.v1beta4.SqlBackupRunsInsertRequest
	(*SqlBackupRunsListRequest)(nil),                                    // 4: google.cloud.sql.v1beta4.SqlBackupRunsListRequest
	(*SqlDatabasesDeleteRequest)(nil),                                   // 5: google.cloud.sql.v1beta4.SqlDatabasesDeleteRequest
	(*SqlDatabasesGetRequest)(nil),                                      // 6: google.cloud.sql.v1beta4.SqlDatabasesGetRequest
	(*SqlDatabasesInsertRequest)(nil),                                   // 7: google.cloud.sql.v1beta4.SqlDatabasesInsertRequest
	(*SqlDatabasesListRequest)(nil),                                     // 8: google.cloud.sql.v1beta4.SqlDatabasesListRequest
	(*SqlDatabasesUpdateRequest)(nil),                                   // 9: google.cloud.sql.v1beta4.SqlDatabasesUpdateRequest
	(*SqlFlagsListRequest)(nil),                                         // 10: google.cloud.sql.v1beta4.SqlFlagsListRequest
	(*SqlInstancesAddServerCaRequest)(nil),                              // 11: google.cloud.sql.v1beta4.SqlInstancesAddServerCaRequest
	(*SqlInstancesCloneRequest)(nil),                                    // 12: google.cloud.sql.v1beta4.SqlInstancesCloneRequest
	(*SqlInstancesDeleteRequest)(nil),                                   // 13: google.cloud.sql.v1beta4.SqlInstancesDeleteRequest
	(*SqlInstancesDemoteMasterRequest)(nil),                             // 14: google.cloud.sql.v1beta4.SqlInstancesDemoteMasterRequest
	(*SqlInstancesExportRequest)(nil),                                   // 15: google.cloud.sql.v1beta4.SqlInstancesExportRequest
	(*SqlInstancesFailoverRequest)(nil),                                 // 16: google.cloud.sql.v1beta4.SqlInstancesFailoverRequest
	(*SqlInstancesGetRequest)(nil),                                      // 17: google.cloud.sql.v1beta4.SqlInstancesGetRequest
	(*SqlInstancesImportRequest)(nil),                                   // 18: google.cloud.sql.v1beta4.SqlInstancesImportRequest
	(*SqlInstancesInsertRequest)(nil),                                   // 19: google.cloud.sql.v1beta4.SqlInstancesInsertRequest
	(*SqlInstancesListRequest)(nil),                                     // 20: google.cloud.sql.v1beta4.SqlInstancesListRequest
	(*SqlInstancesListServerCasRequest)(nil),                            // 21: google.cloud.sql.v1beta4.SqlInstancesListServerCasRequest
	(*SqlInstancesPatchRequest)(nil),                                    // 22: google.cloud.sql.v1beta4.SqlInstancesPatchRequest
	(*SqlInstancesPromoteReplicaRequest)(nil),                           // 23: google.cloud.sql.v1beta4.SqlInstancesPromoteReplicaRequest
	(*SqlInstancesResetSslConfigRequest)(nil),                           // 24: google.cloud.sql.v1beta4.SqlInstancesResetSslConfigRequest
	(*SqlInstancesRestartRequest)(nil),                                  // 25: google.cloud.sql.v1beta4.SqlInstancesRestartRequest
	(*SqlInstancesRestoreBackupRequest)(nil),                            // 26: google.cloud.sql.v1beta4.SqlInstancesRestoreBackupRequest
	(*SqlInstancesRotateServerCaRequest)(nil),                           // 27: google.cloud.sql.v1beta4.SqlInstancesRotateServerCaRequest
	(*SqlInstancesStartReplicaRequest)(nil),                             // 28: google.cloud.sql.v1beta4.SqlInstancesStartReplicaRequest
	(*SqlInstancesStopReplicaRequest)(nil),                              // 29: google.cloud.sql.v1beta4.SqlInstancesStopReplicaRequest
	(*SqlInstancesTruncateLogRequest)(nil),                              // 30: google.cloud.sql.v1beta4.SqlInstancesTruncateLogRequest
	(*SqlInstancesUpdateRequest)(nil),                                   // 31: google.cloud.sql.v1beta4.SqlInstancesUpdateRequest
	(*SqlInstancesRescheduleMaintenanceRequest)(nil),                    // 32: google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequest
	(*SqlInstancesVerifyExternalSyncSettingsRequest)(nil),               // 33: google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsRequest
	(*SqlInstancesStartExternalSyncRequest)(nil),                        // 34: google.cloud.sql.v1beta4.SqlInstancesStartExternalSyncRequest
	(*SqlOperationsGetRequest)(nil),                                     // 35: google.cloud.sql.v1beta4.SqlOperationsGetRequest
	(*SqlOperationsListRequest)(nil),                                    // 36: google.cloud.sql.v1beta4.SqlOperationsListRequest
	(*SqlInstancesCreateEphemeralCertRequest)(nil),                      // 37: google.cloud.sql.v1beta4.SqlInstancesCreateEphemeralCertRequest
	(*SqlSslCertsDeleteRequest)(nil),                                    // 38: google.cloud.sql.v1beta4.SqlSslCertsDeleteRequest
	(*SqlSslCertsGetRequest)(nil),                                       // 39: google.cloud.sql.v1beta4.SqlSslCertsGetRequest
	(*SqlSslCertsInsertRequest)(nil),                                    // 40: google.cloud.sql.v1beta4.SqlSslCertsInsertRequest
	(*SqlSslCertsListRequest)(nil),                                      // 41: google.cloud.sql.v1beta4.SqlSslCertsListRequest
	(*BackupRun)(nil),                                                   // 42: google.cloud.sql.v1beta4.BackupRun
	(*Database)(nil),                                                    // 43: google.cloud.sql.v1beta4.Database
	(*InstancesCloneRequest)(nil),                                       // 44: google.cloud.sql.v1beta4.InstancesCloneRequest
	(*InstancesDemoteMasterRequest)(nil),                                // 45: google.cloud.sql.v1beta4.InstancesDemoteMasterRequest
	(*InstancesExportRequest)(nil),                                      // 46: google.cloud.sql.v1beta4.InstancesExportRequest
	(*InstancesFailoverRequest)(nil),                                    // 47: google.cloud.sql.v1beta4.InstancesFailoverRequest
	(*InstancesImportRequest)(nil),                                      // 48: google.cloud.sql.v1beta4.InstancesImportRequest
	(*DatabaseInstance)(nil),                                            // 49: google.cloud.sql.v1beta4.DatabaseInstance
	(*InstancesRestoreBackupRequest)(nil),                               // 50: google.cloud.sql.v1beta4.InstancesRestoreBackupRequest
	(*InstancesRotateServerCaRequest)(nil),                              // 51: google.cloud.sql.v1beta4.InstancesRotateServerCaRequest
	(*InstancesTruncateLogRequest)(nil),                                 // 52: google.cloud.sql.v1beta4.InstancesTruncateLogRequest
	(*SqlInstancesRescheduleMaintenanceRequestBody)(nil),                // 53: google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody
	(*MySqlSyncConfig)(nil),                                             // 54: google.cloud.sql.v1beta4.MySqlSyncConfig
	(*SslCertsCreateEphemeralRequest)(nil),                              // 55: google.cloud.sql.v1beta4.SslCertsCreateEphemeralRequest
	(*SslCertsInsertRequest)(nil),                                       // 56: google.cloud.sql.v1beta4.SslCertsInsertRequest
	(*Operation)(nil),                                                   // 57: google.cloud.sql.v1beta4.Operation
	(*BackupRunsListResponse)(nil),                                      // 58: google.cloud.sql.v1beta4.BackupRunsListResponse
	(*DatabasesListResponse)(nil),                                       // 59: google.cloud.sql.v1beta4.DatabasesListResponse
	(*FlagsListResponse)(nil),                                           // 60: google.cloud.sql.v1beta4.FlagsListResponse
	(*InstancesListResponse)(nil),                                       // 61: google.cloud.sql.v1beta4.InstancesListResponse
	(*InstancesListServerCasResponse)(nil),                              // 62: google.cloud.sql.v1beta4.InstancesListServerCasResponse
	(*SslCert)(nil),                                                     // 63: google.cloud.sql.v1beta4.SslCert
	(*SqlInstancesVerifyExternalSyncSettingsResponse)(nil),              // 64: google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsResponse
	(*OperationsListResponse)(nil),                                      // 65: google.cloud.sql.v1beta4.OperationsListResponse
	(*SslCertsInsertResponse)(nil),                                      // 66: google.cloud.sql.v1beta4.SslCertsInsertResponse
	(*SslCertsListResponse)(nil),                                        // 67: google.cloud.sql.v1beta4.SslCertsListResponse
}
var file_google_cloud_sql_v1beta4_cloud_sql_proto_depIdxs = []int32{
	42, // 0: google.cloud.sql.v1beta4.SqlBackupRunsInsertRequest.body:type_name -> google.cloud.sql.v1beta4.BackupRun
	43, // 1: google.cloud.sql.v1beta4.SqlDatabasesInsertRequest.body:type_name -> google.cloud.sql.v1beta4.Database
	43, // 2: google.cloud.sql.v1beta4.SqlDatabasesUpdateRequest.body:type_name -> google.cloud.sql.v1beta4.Database
	44, // 3: google.cloud.sql.v1beta4.SqlInstancesCloneRequest.body:type_name -> google.cloud.sql.v1beta4.InstancesCloneRequest
	45, // 4: google.cloud.sql.v1beta4.SqlInstancesDemoteMasterRequest.body:type_name -> google.cloud.sql.v1beta4.InstancesDemoteMasterRequest
	46, // 5: google.cloud.sql.v1beta4.SqlInstancesExportRequest.body:type_name -> google.cloud.sql.v1beta4.InstancesExportRequest
	47, // 6: google.cloud.sql.v1beta4.SqlInstancesFailoverRequest.body:type_name -> google.cloud.sql.v1beta4.InstancesFailoverRequest
	48, // 7: google.cloud.sql.v1beta4.SqlInstancesImportRequest.body:type_name -> google.cloud.sql.v1beta4.InstancesImportRequest
	49, // 8: google.cloud.sql.v1beta4.SqlInstancesInsertRequest.body:type_name -> google.cloud.sql.v1beta4.DatabaseInstance
	49, // 9: google.cloud.sql.v1beta4.SqlInstancesPatchRequest.body:type_name -> google.cloud.sql.v1beta4.DatabaseInstance
	50, // 10: google.cloud.sql.v1beta4.SqlInstancesRestoreBackupRequest.body:type_name -> google.cloud.sql.v1beta4.InstancesRestoreBackupRequest
	51, // 11: google.cloud.sql.v1beta4.SqlInstancesRotateServerCaRequest.body:type_name -> google.cloud.sql.v1beta4.InstancesRotateServerCaRequest
	52, // 12: google.cloud.sql.v1beta4.SqlInstancesTruncateLogRequest.body:type_name -> google.cloud.sql.v1beta4.InstancesTruncateLogRequest
	49, // 13: google.cloud.sql.v1beta4.SqlInstancesUpdateRequest.body:type_name -> google.cloud.sql.v1beta4.DatabaseInstance
	53, // 14: google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequest.body:type_name -> google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody
	0,  // 15: google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsRequest.sync_mode:type_name -> google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsRequest.ExternalSyncMode
	54, // 16: google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsRequest.mysql_sync_config:type_name -> google.cloud.sql.v1beta4.MySqlSyncConfig
	0,  // 17: google.cloud.sql.v1beta4.SqlInstancesStartExternalSyncRequest.sync_mode:type_name -> google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsRequest.ExternalSyncMode
	54, // 18: google.cloud.sql.v1beta4.SqlInstancesStartExternalSyncRequest.mysql_sync_config:type_name -> google.cloud.sql.v1beta4.MySqlSyncConfig
	55, // 19: google.cloud.sql.v1beta4.SqlInstancesCreateEphemeralCertRequest.body:type_name -> google.cloud.sql.v1beta4.SslCertsCreateEphemeralRequest
	56, // 20: google.cloud.sql.v1beta4.SqlSslCertsInsertRequest.body:type_name -> google.cloud.sql.v1beta4.SslCertsInsertRequest
	1,  // 21: google.cloud.sql.v1beta4.SqlBackupRunsService.Delete:input_type -> google.cloud.sql.v1beta4.SqlBackupRunsDeleteRequest
	2,  // 22: google.cloud.sql.v1beta4.SqlBackupRunsService.Get:input_type -> google.cloud.sql.v1beta4.SqlBackupRunsGetRequest
	3,  // 23: google.cloud.sql.v1beta4.SqlBackupRunsService.Insert:input_type -> google.cloud.sql.v1beta4.SqlBackupRunsInsertRequest
	4,  // 24: google.cloud.sql.v1beta4.SqlBackupRunsService.List:input_type -> google.cloud.sql.v1beta4.SqlBackupRunsListRequest
	5,  // 25: google.cloud.sql.v1beta4.SqlDatabasesService.Delete:input_type -> google.cloud.sql.v1beta4.SqlDatabasesDeleteRequest
	6,  // 26: google.cloud.sql.v1beta4.SqlDatabasesService.Get:input_type -> google.cloud.sql.v1beta4.SqlDatabasesGetRequest
	7,  // 27: google.cloud.sql.v1beta4.SqlDatabasesService.Insert:input_type -> google.cloud.sql.v1beta4.SqlDatabasesInsertRequest
	8,  // 28: google.cloud.sql.v1beta4.SqlDatabasesService.List:input_type -> google.cloud.sql.v1beta4.SqlDatabasesListRequest
	9,  // 29: google.cloud.sql.v1beta4.SqlDatabasesService.Patch:input_type -> google.cloud.sql.v1beta4.SqlDatabasesUpdateRequest
	9,  // 30: google.cloud.sql.v1beta4.SqlDatabasesService.Update:input_type -> google.cloud.sql.v1beta4.SqlDatabasesUpdateRequest
	10, // 31: google.cloud.sql.v1beta4.SqlFlagsService.List:input_type -> google.cloud.sql.v1beta4.SqlFlagsListRequest
	11, // 32: google.cloud.sql.v1beta4.SqlInstancesService.AddServerCa:input_type -> google.cloud.sql.v1beta4.SqlInstancesAddServerCaRequest
	12, // 33: google.cloud.sql.v1beta4.SqlInstancesService.Clone:input_type -> google.cloud.sql.v1beta4.SqlInstancesCloneRequest
	13, // 34: google.cloud.sql.v1beta4.SqlInstancesService.Delete:input_type -> google.cloud.sql.v1beta4.SqlInstancesDeleteRequest
	14, // 35: google.cloud.sql.v1beta4.SqlInstancesService.DemoteMaster:input_type -> google.cloud.sql.v1beta4.SqlInstancesDemoteMasterRequest
	15, // 36: google.cloud.sql.v1beta4.SqlInstancesService.Export:input_type -> google.cloud.sql.v1beta4.SqlInstancesExportRequest
	16, // 37: google.cloud.sql.v1beta4.SqlInstancesService.Failover:input_type -> google.cloud.sql.v1beta4.SqlInstancesFailoverRequest
	17, // 38: google.cloud.sql.v1beta4.SqlInstancesService.Get:input_type -> google.cloud.sql.v1beta4.SqlInstancesGetRequest
	18, // 39: google.cloud.sql.v1beta4.SqlInstancesService.Import:input_type -> google.cloud.sql.v1beta4.SqlInstancesImportRequest
	19, // 40: google.cloud.sql.v1beta4.SqlInstancesService.Insert:input_type -> google.cloud.sql.v1beta4.SqlInstancesInsertRequest
	20, // 41: google.cloud.sql.v1beta4.SqlInstancesService.List:input_type -> google.cloud.sql.v1beta4.SqlInstancesListRequest
	21, // 42: google.cloud.sql.v1beta4.SqlInstancesService.ListServerCas:input_type -> google.cloud.sql.v1beta4.SqlInstancesListServerCasRequest
	22, // 43: google.cloud.sql.v1beta4.SqlInstancesService.Patch:input_type -> google.cloud.sql.v1beta4.SqlInstancesPatchRequest
	23, // 44: google.cloud.sql.v1beta4.SqlInstancesService.PromoteReplica:input_type -> google.cloud.sql.v1beta4.SqlInstancesPromoteReplicaRequest
	24, // 45: google.cloud.sql.v1beta4.SqlInstancesService.ResetSslConfig:input_type -> google.cloud.sql.v1beta4.SqlInstancesResetSslConfigRequest
	25, // 46: google.cloud.sql.v1beta4.SqlInstancesService.Restart:input_type -> google.cloud.sql.v1beta4.SqlInstancesRestartRequest
	26, // 47: google.cloud.sql.v1beta4.SqlInstancesService.RestoreBackup:input_type -> google.cloud.sql.v1beta4.SqlInstancesRestoreBackupRequest
	27, // 48: google.cloud.sql.v1beta4.SqlInstancesService.RotateServerCa:input_type -> google.cloud.sql.v1beta4.SqlInstancesRotateServerCaRequest
	28, // 49: google.cloud.sql.v1beta4.SqlInstancesService.StartReplica:input_type -> google.cloud.sql.v1beta4.SqlInstancesStartReplicaRequest
	29, // 50: google.cloud.sql.v1beta4.SqlInstancesService.StopReplica:input_type -> google.cloud.sql.v1beta4.SqlInstancesStopReplicaRequest
	30, // 51: google.cloud.sql.v1beta4.SqlInstancesService.TruncateLog:input_type -> google.cloud.sql.v1beta4.SqlInstancesTruncateLogRequest
	31, // 52: google.cloud.sql.v1beta4.SqlInstancesService.Update:input_type -> google.cloud.sql.v1beta4.SqlInstancesUpdateRequest
	37, // 53: google.cloud.sql.v1beta4.SqlInstancesService.CreateEphemeral:input_type -> google.cloud.sql.v1beta4.SqlInstancesCreateEphemeralCertRequest
	32, // 54: google.cloud.sql.v1beta4.SqlInstancesService.RescheduleMaintenance:input_type -> google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequest
	33, // 55: google.cloud.sql.v1beta4.SqlInstancesService.VerifyExternalSyncSettings:input_type -> google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsRequest
	34, // 56: google.cloud.sql.v1beta4.SqlInstancesService.StartExternalSync:input_type -> google.cloud.sql.v1beta4.SqlInstancesStartExternalSyncRequest
	35, // 57: google.cloud.sql.v1beta4.SqlOperationsService.Get:input_type -> google.cloud.sql.v1beta4.SqlOperationsGetRequest
	36, // 58: google.cloud.sql.v1beta4.SqlOperationsService.List:input_type -> google.cloud.sql.v1beta4.SqlOperationsListRequest
	38, // 59: google.cloud.sql.v1beta4.SqlSslCertsService.Delete:input_type -> google.cloud.sql.v1beta4.SqlSslCertsDeleteRequest
	39, // 60: google.cloud.sql.v1beta4.SqlSslCertsService.Get:input_type -> google.cloud.sql.v1beta4.SqlSslCertsGetRequest
	40, // 61: google.cloud.sql.v1beta4.SqlSslCertsService.Insert:input_type -> google.cloud.sql.v1beta4.SqlSslCertsInsertRequest
	41, // 62: google.cloud.sql.v1beta4.SqlSslCertsService.List:input_type -> google.cloud.sql.v1beta4.SqlSslCertsListRequest
	57, // 63: google.cloud.sql.v1beta4.SqlBackupRunsService.Delete:output_type -> google.cloud.sql.v1beta4.Operation
	42, // 64: google.cloud.sql.v1beta4.SqlBackupRunsService.Get:output_type -> google.cloud.sql.v1beta4.BackupRun
	57, // 65: google.cloud.sql.v1beta4.SqlBackupRunsService.Insert:output_type -> google.cloud.sql.v1beta4.Operation
	58, // 66: google.cloud.sql.v1beta4.SqlBackupRunsService.List:output_type -> google.cloud.sql.v1beta4.BackupRunsListResponse
	57, // 67: google.cloud.sql.v1beta4.SqlDatabasesService.Delete:output_type -> google.cloud.sql.v1beta4.Operation
	43, // 68: google.cloud.sql.v1beta4.SqlDatabasesService.Get:output_type -> google.cloud.sql.v1beta4.Database
	57, // 69: google.cloud.sql.v1beta4.SqlDatabasesService.Insert:output_type -> google.cloud.sql.v1beta4.Operation
	59, // 70: google.cloud.sql.v1beta4.SqlDatabasesService.List:output_type -> google.cloud.sql.v1beta4.DatabasesListResponse
	57, // 71: google.cloud.sql.v1beta4.SqlDatabasesService.Patch:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 72: google.cloud.sql.v1beta4.SqlDatabasesService.Update:output_type -> google.cloud.sql.v1beta4.Operation
	60, // 73: google.cloud.sql.v1beta4.SqlFlagsService.List:output_type -> google.cloud.sql.v1beta4.FlagsListResponse
	57, // 74: google.cloud.sql.v1beta4.SqlInstancesService.AddServerCa:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 75: google.cloud.sql.v1beta4.SqlInstancesService.Clone:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 76: google.cloud.sql.v1beta4.SqlInstancesService.Delete:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 77: google.cloud.sql.v1beta4.SqlInstancesService.DemoteMaster:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 78: google.cloud.sql.v1beta4.SqlInstancesService.Export:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 79: google.cloud.sql.v1beta4.SqlInstancesService.Failover:output_type -> google.cloud.sql.v1beta4.Operation
	49, // 80: google.cloud.sql.v1beta4.SqlInstancesService.Get:output_type -> google.cloud.sql.v1beta4.DatabaseInstance
	57, // 81: google.cloud.sql.v1beta4.SqlInstancesService.Import:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 82: google.cloud.sql.v1beta4.SqlInstancesService.Insert:output_type -> google.cloud.sql.v1beta4.Operation
	61, // 83: google.cloud.sql.v1beta4.SqlInstancesService.List:output_type -> google.cloud.sql.v1beta4.InstancesListResponse
	62, // 84: google.cloud.sql.v1beta4.SqlInstancesService.ListServerCas:output_type -> google.cloud.sql.v1beta4.InstancesListServerCasResponse
	57, // 85: google.cloud.sql.v1beta4.SqlInstancesService.Patch:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 86: google.cloud.sql.v1beta4.SqlInstancesService.PromoteReplica:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 87: google.cloud.sql.v1beta4.SqlInstancesService.ResetSslConfig:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 88: google.cloud.sql.v1beta4.SqlInstancesService.Restart:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 89: google.cloud.sql.v1beta4.SqlInstancesService.RestoreBackup:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 90: google.cloud.sql.v1beta4.SqlInstancesService.RotateServerCa:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 91: google.cloud.sql.v1beta4.SqlInstancesService.StartReplica:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 92: google.cloud.sql.v1beta4.SqlInstancesService.StopReplica:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 93: google.cloud.sql.v1beta4.SqlInstancesService.TruncateLog:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 94: google.cloud.sql.v1beta4.SqlInstancesService.Update:output_type -> google.cloud.sql.v1beta4.Operation
	63, // 95: google.cloud.sql.v1beta4.SqlInstancesService.CreateEphemeral:output_type -> google.cloud.sql.v1beta4.SslCert
	57, // 96: google.cloud.sql.v1beta4.SqlInstancesService.RescheduleMaintenance:output_type -> google.cloud.sql.v1beta4.Operation
	64, // 97: google.cloud.sql.v1beta4.SqlInstancesService.VerifyExternalSyncSettings:output_type -> google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsResponse
	57, // 98: google.cloud.sql.v1beta4.SqlInstancesService.StartExternalSync:output_type -> google.cloud.sql.v1beta4.Operation
	57, // 99: google.cloud.sql.v1beta4.SqlOperationsService.Get:output_type -> google.cloud.sql.v1beta4.Operation
	65, // 100: google.cloud.sql.v1beta4.SqlOperationsService.List:output_type -> google.cloud.sql.v1beta4.OperationsListResponse
	57, // 101: google.cloud.sql.v1beta4.SqlSslCertsService.Delete:output_type -> google.cloud.sql.v1beta4.Operation
	63, // 102: google.cloud.sql.v1beta4.SqlSslCertsService.Get:output_type -> google.cloud.sql.v1beta4.SslCert
	66, // 103: google.cloud.sql.v1beta4.SqlSslCertsService.Insert:output_type -> google.cloud.sql.v1beta4.SslCertsInsertResponse
	67, // 104: google.cloud.sql.v1beta4.SqlSslCertsService.List:output_type -> google.cloud.sql.v1beta4.SslCertsListResponse
	63, // [63:105] is the sub-list for method output_type
	21, // [21:63] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_sql_v1beta4_cloud_sql_proto_init() }
func file_google_cloud_sql_v1beta4_cloud_sql_proto_init() {
	if File_google_cloud_sql_v1beta4_cloud_sql_proto != nil {
		return
	}
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlBackupRunsDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlBackupRunsGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlBackupRunsInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlBackupRunsListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlDatabasesDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlDatabasesGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlDatabasesInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlDatabasesListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlDatabasesUpdateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlFlagsListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesAddServerCaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesCloneRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesDemoteMasterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesFailoverRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesImportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesListServerCasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesPatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesPromoteReplicaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesResetSslConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRestartRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRestoreBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRotateServerCaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesStartReplicaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesStopReplicaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesTruncateLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesUpdateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRescheduleMaintenanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesVerifyExternalSyncSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesStartExternalSyncRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlOperationsGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlOperationsListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesCreateEphemeralCertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlSslCertsDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlSslCertsGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlSslCertsInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlSslCertsListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[32].OneofWrappers = []interface{}{
		(*SqlInstancesVerifyExternalSyncSettingsRequest_MysqlSyncConfig)(nil),
	}
	file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes[33].OneofWrappers = []interface{}{
		(*SqlInstancesStartExternalSyncRequest_MysqlSyncConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   41,
			NumExtensions: 0,
			NumServices:   6,
		},
		GoTypes:           file_google_cloud_sql_v1beta4_cloud_sql_proto_goTypes,
		DependencyIndexes: file_google_cloud_sql_v1beta4_cloud_sql_proto_depIdxs,
		EnumInfos:         file_google_cloud_sql_v1beta4_cloud_sql_proto_enumTypes,
		MessageInfos:      file_google_cloud_sql_v1beta4_cloud_sql_proto_msgTypes,
	}.Build()
	File_google_cloud_sql_v1beta4_cloud_sql_proto = out.File
	file_google_cloud_sql_v1beta4_cloud_sql_proto_rawDesc = nil
	file_google_cloud_sql_v1beta4_cloud_sql_proto_goTypes = nil
	file_google_cloud_sql_v1beta4_cloud_sql_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SqlBackupRunsServiceClient is the client API for SqlBackupRunsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlBackupRunsServiceClient interface {
	// Deletes the backup taken by a backup run.
	Delete(ctx context.Context, in *SqlBackupRunsDeleteRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a resource containing information about a backup run.
	Get(ctx context.Context, in *SqlBackupRunsGetRequest, opts ...grpc.CallOption) (*BackupRun, error)
	// Creates a new backup run on demand.
	Insert(ctx context.Context, in *SqlBackupRunsInsertRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all backup runs associated with the project or a given instance and
	// configuration in the reverse chronological order of the backup initiation
	// time.
	List(ctx context.Context, in *SqlBackupRunsListRequest, opts ...grpc.CallOption) (*BackupRunsListResponse, error)
}

type sqlBackupRunsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlBackupRunsServiceClient(cc grpc.ClientConnInterface) SqlBackupRunsServiceClient {
	return &sqlBackupRunsServiceClient{cc}
}

func (c *sqlBackupRunsServiceClient) Delete(ctx context.Context, in *SqlBackupRunsDeleteRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlBackupRunsService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlBackupRunsServiceClient) Get(ctx context.Context, in *SqlBackupRunsGetRequest, opts ...grpc.CallOption) (*BackupRun, error) {
	out := new(BackupRun)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlBackupRunsService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlBackupRunsServiceClient) Insert(ctx context.Context, in *SqlBackupRunsInsertRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlBackupRunsService/Insert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlBackupRunsServiceClient) List(ctx context.Context, in *SqlBackupRunsListRequest, opts ...grpc.CallOption) (*BackupRunsListResponse, error) {
	out := new(BackupRunsListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlBackupRunsService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlBackupRunsServiceServer is the server API for SqlBackupRunsService service.
type SqlBackupRunsServiceServer interface {
	// Deletes the backup taken by a backup run.
	Delete(context.Context, *SqlBackupRunsDeleteRequest) (*Operation, error)
	// Retrieves a resource containing information about a backup run.
	Get(context.Context, *SqlBackupRunsGetRequest) (*BackupRun, error)
	// Creates a new backup run on demand.
	Insert(context.Context, *SqlBackupRunsInsertRequest) (*Operation, error)
	// Lists all backup runs associated with the project or a given instance and
	// configuration in the reverse chronological order of the backup initiation
	// time.
	List(context.Context, *SqlBackupRunsListRequest) (*BackupRunsListResponse, error)
}

// UnimplementedSqlBackupRunsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlBackupRunsServiceServer struct {
}

func (*UnimplementedSqlBackupRunsServiceServer) Delete(context.Context, *SqlBackupRunsDeleteRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSqlBackupRunsServiceServer) Get(context.Context, *SqlBackupRunsGetRequest) (*BackupRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSqlBackupRunsServiceServer) Insert(context.Context, *SqlBackupRunsInsertRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (*UnimplementedSqlBackupRunsServiceServer) List(context.Context, *SqlBackupRunsListRequest) (*BackupRunsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

func RegisterSqlBackupRunsServiceServer(s *grpc.Server, srv SqlBackupRunsServiceServer) {
	s.RegisterService(&_SqlBackupRunsService_serviceDesc, srv)
}

func _SqlBackupRunsService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlBackupRunsDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlBackupRunsServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlBackupRunsService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlBackupRunsServiceServer).Delete(ctx, req.(*SqlBackupRunsDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlBackupRunsService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlBackupRunsGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlBackupRunsServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlBackupRunsService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlBackupRunsServiceServer).Get(ctx, req.(*SqlBackupRunsGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlBackupRunsService_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlBackupRunsInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlBackupRunsServiceServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlBackupRunsService/Insert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlBackupRunsServiceServer).Insert(ctx, req.(*SqlBackupRunsInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlBackupRunsService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlBackupRunsListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlBackupRunsServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlBackupRunsService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlBackupRunsServiceServer).List(ctx, req.(*SqlBackupRunsListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlBackupRunsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1beta4.SqlBackupRunsService",
	HandlerType: (*SqlBackupRunsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _SqlBackupRunsService_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SqlBackupRunsService_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _SqlBackupRunsService_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SqlBackupRunsService_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1beta4/cloud_sql.proto",
}

// SqlDatabasesServiceClient is the client API for SqlDatabasesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlDatabasesServiceClient interface {
	// Deletes a database from a Cloud SQL instance.
	Delete(ctx context.Context, in *SqlDatabasesDeleteRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a resource containing information about a database inside a Cloud
	// SQL instance.
	Get(ctx context.Context, in *SqlDatabasesGetRequest, opts ...grpc.CallOption) (*Database, error)
	// Inserts a resource containing information about a database inside a Cloud
	// SQL instance.
	Insert(ctx context.Context, in *SqlDatabasesInsertRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists databases in the specified Cloud SQL instance.
	List(ctx context.Context, in *SqlDatabasesListRequest, opts ...grpc.CallOption) (*DatabasesListResponse, error)
	// Partially updates a resource containing information about a database inside
	// a Cloud SQL instance. This method supports patch semantics.
	Patch(ctx context.Context, in *SqlDatabasesUpdateRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates a resource containing information about a database inside a Cloud
	// SQL instance.
	Update(ctx context.Context, in *SqlDatabasesUpdateRequest, opts ...grpc.CallOption) (*Operation, error)
}

type sqlDatabasesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlDatabasesServiceClient(cc grpc.ClientConnInterface) SqlDatabasesServiceClient {
	return &sqlDatabasesServiceClient{cc}
}

func (c *sqlDatabasesServiceClient) Delete(ctx context.Context, in *SqlDatabasesDeleteRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlDatabasesService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlDatabasesServiceClient) Get(ctx context.Context, in *SqlDatabasesGetRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlDatabasesService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlDatabasesServiceClient) Insert(ctx context.Context, in *SqlDatabasesInsertRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlDatabasesService/Insert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlDatabasesServiceClient) List(ctx context.Context, in *SqlDatabasesListRequest, opts ...grpc.CallOption) (*DatabasesListResponse, error) {
	out := new(DatabasesListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlDatabasesService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlDatabasesServiceClient) Patch(ctx context.Context, in *SqlDatabasesUpdateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlDatabasesService/Patch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlDatabasesServiceClient) Update(ctx context.Context, in *SqlDatabasesUpdateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlDatabasesService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlDatabasesServiceServer is the server API for SqlDatabasesService service.
type SqlDatabasesServiceServer interface {
	// Deletes a database from a Cloud SQL instance.
	Delete(context.Context, *SqlDatabasesDeleteRequest) (*Operation, error)
	// Retrieves a resource containing information about a database inside a Cloud
	// SQL instance.
	Get(context.Context, *SqlDatabasesGetRequest) (*Database, error)
	// Inserts a resource containing information about a database inside a Cloud
	// SQL instance.
	Insert(context.Context, *SqlDatabasesInsertRequest) (*Operation, error)
	// Lists databases in the specified Cloud SQL instance.
	List(context.Context, *SqlDatabasesListRequest) (*DatabasesListResponse, error)
	// Partially updates a resource containing information about a database inside
	// a Cloud SQL instance. This method supports patch semantics.
	Patch(context.Context, *SqlDatabasesUpdateRequest) (*Operation, error)
	// Updates a resource containing information about a database inside a Cloud
	// SQL instance.
	Update(context.Context, *SqlDatabasesUpdateRequest) (*Operation, error)
}

// UnimplementedSqlDatabasesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlDatabasesServiceServer struct {
}

func (*UnimplementedSqlDatabasesServiceServer) Delete(context.Context, *SqlDatabasesDeleteRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSqlDatabasesServiceServer) Get(context.Context, *SqlDatabasesGetRequest) (*Database, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSqlDatabasesServiceServer) Insert(context.Context, *SqlDatabasesInsertRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (*UnimplementedSqlDatabasesServiceServer) List(context.Context, *SqlDatabasesListRequest) (*DatabasesListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedSqlDatabasesServiceServer) Patch(context.Context, *SqlDatabasesUpdateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (*UnimplementedSqlDatabasesServiceServer) Update(context.Context, *SqlDatabasesUpdateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

func RegisterSqlDatabasesServiceServer(s *grpc.Server, srv SqlDatabasesServiceServer) {
	s.RegisterService(&_SqlDatabasesService_serviceDesc, srv)
}

func _SqlDatabasesService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlDatabasesService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).Delete(ctx, req.(*SqlDatabasesDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlDatabasesService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlDatabasesService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).Get(ctx, req.(*SqlDatabasesGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlDatabasesService_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlDatabasesService/Insert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).Insert(ctx, req.(*SqlDatabasesInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlDatabasesService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlDatabasesService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).List(ctx, req.(*SqlDatabasesListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlDatabasesService_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlDatabasesService/Patch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).Patch(ctx, req.(*SqlDatabasesUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlDatabasesService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlDatabasesService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).Update(ctx, req.(*SqlDatabasesUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlDatabasesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1beta4.SqlDatabasesService",
	HandlerType: (*SqlDatabasesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _SqlDatabasesService_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SqlDatabasesService_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _SqlDatabasesService_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SqlDatabasesService_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _SqlDatabasesService_Patch_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SqlDatabasesService_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1beta4/cloud_sql.proto",
}

// SqlFlagsServiceClient is the client API for SqlFlagsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlFlagsServiceClient interface {
	// Lists all available database flags for Cloud SQL instances.
	List(ctx context.Context, in *SqlFlagsListRequest, opts ...grpc.CallOption) (*FlagsListResponse, error)
}

type sqlFlagsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlFlagsServiceClient(cc grpc.ClientConnInterface) SqlFlagsServiceClient {
	return &sqlFlagsServiceClient{cc}
}

func (c *sqlFlagsServiceClient) List(ctx context.Context, in *SqlFlagsListRequest, opts ...grpc.CallOption) (*FlagsListResponse, error) {
	out := new(FlagsListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlFlagsService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlFlagsServiceServer is the server API for SqlFlagsService service.
type SqlFlagsServiceServer interface {
	// Lists all available database flags for Cloud SQL instances.
	List(context.Context, *SqlFlagsListRequest) (*FlagsListResponse, error)
}

// UnimplementedSqlFlagsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlFlagsServiceServer struct {
}

func (*UnimplementedSqlFlagsServiceServer) List(context.Context, *SqlFlagsListRequest) (*FlagsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

func RegisterSqlFlagsServiceServer(s *grpc.Server, srv SqlFlagsServiceServer) {
	s.RegisterService(&_SqlFlagsService_serviceDesc, srv)
}

func _SqlFlagsService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlFlagsListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlFlagsServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlFlagsService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlFlagsServiceServer).List(ctx, req.(*SqlFlagsListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlFlagsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1beta4.SqlFlagsService",
	HandlerType: (*SqlFlagsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _SqlFlagsService_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1beta4/cloud_sql.proto",
}

// SqlInstancesServiceClient is the client API for SqlInstancesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlInstancesServiceClient interface {
	// Add a new trusted Certificate Authority (CA) version for the specified
	// instance. Required to prepare for a certificate rotation. If a CA version
	// was previously added but never used in a certificate rotation, this
	// operation replaces that version. There cannot be more than one CA version
	// waiting to be rotated in.
	AddServerCa(ctx context.Context, in *SqlInstancesAddServerCaRequest, opts ...grpc.CallOption) (*Operation, error)
	// Creates a Cloud SQL instance as a clone of the source instance. Using this
	// operation might cause your instance to restart.
	Clone(ctx context.Context, in *SqlInstancesCloneRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a Cloud SQL instance.
	Delete(ctx context.Context, in *SqlInstancesDeleteRequest, opts ...grpc.CallOption) (*Operation, error)
	// Demotes the stand-alone instance to be a Cloud SQL read replica for an
	// external database server.
	DemoteMaster(ctx context.Context, in *SqlInstancesDemoteMasterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Exports data from a Cloud SQL instance to a Cloud Storage bucket as a SQL
	// dump or CSV file.
	Export(ctx context.Context, in *SqlInstancesExportRequest, opts ...grpc.CallOption) (*Operation, error)
	// Initiates a manual failover of a high availability (HA) primary instance
	// to a standby instance, which becomes the primary instance. Users are
	// then rerouted to the new primary. For more information, see the
	// [Overview of high
	// availability](https://cloud.google.com/sql/docs/mysql/high-availability)
	// page in the Cloud SQL documentation.
	// If using Legacy HA (MySQL only), this causes the instance to failover to
	// its failover replica instance.
	Failover(ctx context.Context, in *SqlInstancesFailoverRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a resource containing information about a Cloud SQL instance.
	Get(ctx context.Context, in *SqlInstancesGetRequest, opts ...grpc.CallOption) (*DatabaseInstance, error)
	// Imports data into a Cloud SQL instance from a SQL dump  or CSV file in
	// Cloud Storage.
	Import(ctx context.Context, in *SqlInstancesImportRequest, opts ...grpc.CallOption) (*Operation, error)
	// Creates a new Cloud SQL instance.
	Insert(ctx context.Context, in *SqlInstancesInsertRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists instances under a given project.
	List(ctx context.Context, in *SqlInstancesListRequest, opts ...grpc.CallOption) (*InstancesListResponse, error)
	// Lists all of the trusted Certificate Authorities (CAs) for the specified
	// instance. There can be up to three CAs listed: the CA that was used to sign
	// the certificate that is currently in use, a CA that has been added but not
	// yet used to sign a certificate, and a CA used to sign a certificate that
	// has previously rotated out.
	ListServerCas(ctx context.Context, in *SqlInstancesListServerCasRequest, opts ...grpc.CallOption) (*InstancesListServerCasResponse, error)
	// Updates settings of a Cloud SQL instance.
	// This method supports patch semantics.
	Patch(ctx context.Context, in *SqlInstancesPatchRequest, opts ...grpc.CallOption) (*Operation, error)
	// Promotes the read replica instance to be a stand-alone Cloud SQL instance.
	// Using this operation might cause your instance to restart.
	PromoteReplica(ctx context.Context, in *SqlInstancesPromoteReplicaRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes all client certificates and generates a new server SSL certificate
	// for the instance.
	ResetSslConfig(ctx context.Context, in *SqlInstancesResetSslConfigRequest, opts ...grpc.CallOption) (*Operation, error)
	// Restarts a Cloud SQL instance.
	Restart(ctx context.Context, in *SqlInstancesRestartRequest, opts ...grpc.CallOption) (*Operation, error)
	// Restores a backup of a Cloud SQL instance. Using this operation might cause
	// your instance to restart.
	RestoreBackup(ctx context.Context, in *SqlInstancesRestoreBackupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Rotates the server certificate to one signed by the Certificate Authority
	// (CA) version previously added with the addServerCA method.
	RotateServerCa(ctx context.Context, in *SqlInstancesRotateServerCaRequest, opts ...grpc.CallOption) (*Operation, error)
	// Starts the replication in the read replica instance.
	StartReplica(ctx context.Context, in *SqlInstancesStartReplicaRequest, opts ...grpc.CallOption) (*Operation, error)
	// Stops the replication in the read replica instance.
	StopReplica(ctx context.Context, in *SqlInstancesStopReplicaRequest, opts ...grpc.CallOption) (*Operation, error)
	// Truncate MySQL general and slow query log tables
	// MySQL only.
	TruncateLog(ctx context.Context, in *SqlInstancesTruncateLogRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates settings of a Cloud SQL instance. Using this operation might cause
	// your instance to restart.
	Update(ctx context.Context, in *SqlInstancesUpdateRequest, opts ...grpc.CallOption) (*Operation, error)
	// Generates a short-lived X509 certificate containing the provided public key
	// and signed by a private key specific to the target instance. Users may use
	// the certificate to authenticate as themselves when connecting to the
	// database.
	CreateEphemeral(ctx context.Context, in *SqlInstancesCreateEphemeralCertRequest, opts ...grpc.CallOption) (*SslCert, error)
	// Reschedules the maintenance on the given instance.
	RescheduleMaintenance(ctx context.Context, in *SqlInstancesRescheduleMaintenanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Verify External primary instance external sync settings.
	VerifyExternalSyncSettings(ctx context.Context, in *SqlInstancesVerifyExternalSyncSettingsRequest, opts ...grpc.CallOption) (*SqlInstancesVerifyExternalSyncSettingsResponse, error)
	// Start External primary instance migration.
	StartExternalSync(ctx context.Context, in *SqlInstancesStartExternalSyncRequest, opts ...grpc.CallOption) (*Operation, error)
}

type sqlInstancesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlInstancesServiceClient(cc grpc.ClientConnInterface) SqlInstancesServiceClient {
	return &sqlInstancesServiceClient{cc}
}

func (c *sqlInstancesServiceClient) AddServerCa(ctx context.Context, in *SqlInstancesAddServerCaRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/AddServerCa", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Clone(ctx context.Context, in *SqlInstancesCloneRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/Clone", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Delete(ctx context.Context, in *SqlInstancesDeleteRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) DemoteMaster(ctx context.Context, in *SqlInstancesDemoteMasterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/DemoteMaster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Export(ctx context.Context, in *SqlInstancesExportRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/Export", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Failover(ctx context.Context, in *SqlInstancesFailoverRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/Failover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Get(ctx context.Context, in *SqlInstancesGetRequest, opts ...grpc.CallOption) (*DatabaseInstance, error) {
	out := new(DatabaseInstance)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Import(ctx context.Context, in *SqlInstancesImportRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/Import", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Insert(ctx context.Context, in *SqlInstancesInsertRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/Insert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) List(ctx context.Context, in *SqlInstancesListRequest, opts ...grpc.CallOption) (*InstancesListResponse, error) {
	out := new(InstancesListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) ListServerCas(ctx context.Context, in *SqlInstancesListServerCasRequest, opts ...grpc.CallOption) (*InstancesListServerCasResponse, error) {
	out := new(InstancesListServerCasResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/ListServerCas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Patch(ctx context.Context, in *SqlInstancesPatchRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/Patch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) PromoteReplica(ctx context.Context, in *SqlInstancesPromoteReplicaRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/PromoteReplica", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) ResetSslConfig(ctx context.Context, in *SqlInstancesResetSslConfigRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/ResetSslConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Restart(ctx context.Context, in *SqlInstancesRestartRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/Restart", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) RestoreBackup(ctx context.Context, in *SqlInstancesRestoreBackupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/RestoreBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) RotateServerCa(ctx context.Context, in *SqlInstancesRotateServerCaRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/RotateServerCa", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) StartReplica(ctx context.Context, in *SqlInstancesStartReplicaRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/StartReplica", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) StopReplica(ctx context.Context, in *SqlInstancesStopReplicaRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/StopReplica", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) TruncateLog(ctx context.Context, in *SqlInstancesTruncateLogRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/TruncateLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) Update(ctx context.Context, in *SqlInstancesUpdateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) CreateEphemeral(ctx context.Context, in *SqlInstancesCreateEphemeralCertRequest, opts ...grpc.CallOption) (*SslCert, error) {
	out := new(SslCert)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/CreateEphemeral", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) RescheduleMaintenance(ctx context.Context, in *SqlInstancesRescheduleMaintenanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/RescheduleMaintenance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) VerifyExternalSyncSettings(ctx context.Context, in *SqlInstancesVerifyExternalSyncSettingsRequest, opts ...grpc.CallOption) (*SqlInstancesVerifyExternalSyncSettingsResponse, error) {
	out := new(SqlInstancesVerifyExternalSyncSettingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/VerifyExternalSyncSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlInstancesServiceClient) StartExternalSync(ctx context.Context, in *SqlInstancesStartExternalSyncRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlInstancesService/StartExternalSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlInstancesServiceServer is the server API for SqlInstancesService service.
type SqlInstancesServiceServer interface {
	// Add a new trusted Certificate Authority (CA) version for the specified
	// instance. Required to prepare for a certificate rotation. If a CA version
	// was previously added but never used in a certificate rotation, this
	// operation replaces that version. There cannot be more than one CA version
	// waiting to be rotated in.
	AddServerCa(context.Context, *SqlInstancesAddServerCaRequest) (*Operation, error)
	// Creates a Cloud SQL instance as a clone of the source instance. Using this
	// operation might cause your instance to restart.
	Clone(context.Context, *SqlInstancesCloneRequest) (*Operation, error)
	// Deletes a Cloud SQL instance.
	Delete(context.Context, *SqlInstancesDeleteRequest) (*Operation, error)
	// Demotes the stand-alone instance to be a Cloud SQL read replica for an
	// external database server.
	DemoteMaster(context.Context, *SqlInstancesDemoteMasterRequest) (*Operation, error)
	// Exports data from a Cloud SQL instance to a Cloud Storage bucket as a SQL
	// dump or CSV file.
	Export(context.Context, *SqlInstancesExportRequest) (*Operation, error)
	// Initiates a manual failover of a high availability (HA) primary instance
	// to a standby instance, which becomes the primary instance. Users are
	// then rerouted to the new primary. For more information, see the
	// [Overview of high
	// availability](https://cloud.google.com/sql/docs/mysql/high-availability)
	// page in the Cloud SQL documentation.
	// If using Legacy HA (MySQL only), this causes the instance to failover to
	// its failover replica instance.
	Failover(context.Context, *SqlInstancesFailoverRequest) (*Operation, error)
	// Retrieves a resource containing information about a Cloud SQL instance.
	Get(context.Context, *SqlInstancesGetRequest) (*DatabaseInstance, error)
	// Imports data into a Cloud SQL instance from a SQL dump  or CSV file in
	// Cloud Storage.
	Import(context.Context, *SqlInstancesImportRequest) (*Operation, error)
	// Creates a new Cloud SQL instance.
	Insert(context.Context, *SqlInstancesInsertRequest) (*Operation, error)
	// Lists instances under a given project.
	List(context.Context, *SqlInstancesListRequest) (*InstancesListResponse, error)
	// Lists all of the trusted Certificate Authorities (CAs) for the specified
	// instance. There can be up to three CAs listed: the CA that was used to sign
	// the certificate that is currently in use, a CA that has been added but not
	// yet used to sign a certificate, and a CA used to sign a certificate that
	// has previously rotated out.
	ListServerCas(context.Context, *SqlInstancesListServerCasRequest) (*InstancesListServerCasResponse, error)
	// Updates settings of a Cloud SQL instance.
	// This method supports patch semantics.
	Patch(context.Context, *SqlInstancesPatchRequest) (*Operation, error)
	// Promotes the read replica instance to be a stand-alone Cloud SQL instance.
	// Using this operation might cause your instance to restart.
	PromoteReplica(context.Context, *SqlInstancesPromoteReplicaRequest) (*Operation, error)
	// Deletes all client certificates and generates a new server SSL certificate
	// for the instance.
	ResetSslConfig(context.Context, *SqlInstancesResetSslConfigRequest) (*Operation, error)
	// Restarts a Cloud SQL instance.
	Restart(context.Context, *SqlInstancesRestartRequest) (*Operation, error)
	// Restores a backup of a Cloud SQL instance. Using this operation might cause
	// your instance to restart.
	RestoreBackup(context.Context, *SqlInstancesRestoreBackupRequest) (*Operation, error)
	// Rotates the server certificate to one signed by the Certificate Authority
	// (CA) version previously added with the addServerCA method.
	RotateServerCa(context.Context, *SqlInstancesRotateServerCaRequest) (*Operation, error)
	// Starts the replication in the read replica instance.
	StartReplica(context.Context, *SqlInstancesStartReplicaRequest) (*Operation, error)
	// Stops the replication in the read replica instance.
	StopReplica(context.Context, *SqlInstancesStopReplicaRequest) (*Operation, error)
	// Truncate MySQL general and slow query log tables
	// MySQL only.
	TruncateLog(context.Context, *SqlInstancesTruncateLogRequest) (*Operation, error)
	// Updates settings of a Cloud SQL instance. Using this operation might cause
	// your instance to restart.
	Update(context.Context, *SqlInstancesUpdateRequest) (*Operation, error)
	// Generates a short-lived X509 certificate containing the provided public key
	// and signed by a private key specific to the target instance. Users may use
	// the certificate to authenticate as themselves when connecting to the
	// database.
	CreateEphemeral(context.Context, *SqlInstancesCreateEphemeralCertRequest) (*SslCert, error)
	// Reschedules the maintenance on the given instance.
	RescheduleMaintenance(context.Context, *SqlInstancesRescheduleMaintenanceRequest) (*Operation, error)
	// Verify External primary instance external sync settings.
	VerifyExternalSyncSettings(context.Context, *SqlInstancesVerifyExternalSyncSettingsRequest) (*SqlInstancesVerifyExternalSyncSettingsResponse, error)
	// Start External primary instance migration.
	StartExternalSync(context.Context, *SqlInstancesStartExternalSyncRequest) (*Operation, error)
}

// UnimplementedSqlInstancesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlInstancesServiceServer struct {
}

func (*UnimplementedSqlInstancesServiceServer) AddServerCa(context.Context, *SqlInstancesAddServerCaRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddServerCa not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Clone(context.Context, *SqlInstancesCloneRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Clone not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Delete(context.Context, *SqlInstancesDeleteRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) DemoteMaster(context.Context, *SqlInstancesDemoteMasterRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DemoteMaster not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Export(context.Context, *SqlInstancesExportRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Export not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Failover(context.Context, *SqlInstancesFailoverRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Failover not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Get(context.Context, *SqlInstancesGetRequest) (*DatabaseInstance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Import(context.Context, *SqlInstancesImportRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Import not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Insert(context.Context, *SqlInstancesInsertRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) List(context.Context, *SqlInstancesListRequest) (*InstancesListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) ListServerCas(context.Context, *SqlInstancesListServerCasRequest) (*InstancesListServerCasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServerCas not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Patch(context.Context, *SqlInstancesPatchRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) PromoteReplica(context.Context, *SqlInstancesPromoteReplicaRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PromoteReplica not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) ResetSslConfig(context.Context, *SqlInstancesResetSslConfigRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetSslConfig not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Restart(context.Context, *SqlInstancesRestartRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Restart not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) RestoreBackup(context.Context, *SqlInstancesRestoreBackupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreBackup not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) RotateServerCa(context.Context, *SqlInstancesRotateServerCaRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RotateServerCa not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) StartReplica(context.Context, *SqlInstancesStartReplicaRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartReplica not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) StopReplica(context.Context, *SqlInstancesStopReplicaRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopReplica not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) TruncateLog(context.Context, *SqlInstancesTruncateLogRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TruncateLog not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) Update(context.Context, *SqlInstancesUpdateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) CreateEphemeral(context.Context, *SqlInstancesCreateEphemeralCertRequest) (*SslCert, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEphemeral not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) RescheduleMaintenance(context.Context, *SqlInstancesRescheduleMaintenanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RescheduleMaintenance not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) VerifyExternalSyncSettings(context.Context, *SqlInstancesVerifyExternalSyncSettingsRequest) (*SqlInstancesVerifyExternalSyncSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyExternalSyncSettings not implemented")
}
func (*UnimplementedSqlInstancesServiceServer) StartExternalSync(context.Context, *SqlInstancesStartExternalSyncRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartExternalSync not implemented")
}

func RegisterSqlInstancesServiceServer(s *grpc.Server, srv SqlInstancesServiceServer) {
	s.RegisterService(&_SqlInstancesService_serviceDesc, srv)
}

func _SqlInstancesService_AddServerCa_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesAddServerCaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).AddServerCa(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/AddServerCa",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).AddServerCa(ctx, req.(*SqlInstancesAddServerCaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Clone_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesCloneRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Clone(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/Clone",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Clone(ctx, req.(*SqlInstancesCloneRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Delete(ctx, req.(*SqlInstancesDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_DemoteMaster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesDemoteMasterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).DemoteMaster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/DemoteMaster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).DemoteMaster(ctx, req.(*SqlInstancesDemoteMasterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Export_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Export(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/Export",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Export(ctx, req.(*SqlInstancesExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Failover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesFailoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Failover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/Failover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Failover(ctx, req.(*SqlInstancesFailoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Get(ctx, req.(*SqlInstancesGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Import_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Import(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/Import",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Import(ctx, req.(*SqlInstancesImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/Insert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Insert(ctx, req.(*SqlInstancesInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).List(ctx, req.(*SqlInstancesListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_ListServerCas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesListServerCasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).ListServerCas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/ListServerCas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).ListServerCas(ctx, req.(*SqlInstancesListServerCasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesPatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/Patch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Patch(ctx, req.(*SqlInstancesPatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_PromoteReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesPromoteReplicaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).PromoteReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/PromoteReplica",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).PromoteReplica(ctx, req.(*SqlInstancesPromoteReplicaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_ResetSslConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesResetSslConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).ResetSslConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/ResetSslConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).ResetSslConfig(ctx, req.(*SqlInstancesResetSslConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Restart_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesRestartRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Restart(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/Restart",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Restart(ctx, req.(*SqlInstancesRestartRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_RestoreBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesRestoreBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).RestoreBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/RestoreBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).RestoreBackup(ctx, req.(*SqlInstancesRestoreBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_RotateServerCa_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesRotateServerCaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).RotateServerCa(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/RotateServerCa",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).RotateServerCa(ctx, req.(*SqlInstancesRotateServerCaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_StartReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesStartReplicaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).StartReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/StartReplica",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).StartReplica(ctx, req.(*SqlInstancesStartReplicaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_StopReplica_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesStopReplicaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).StopReplica(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/StopReplica",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).StopReplica(ctx, req.(*SqlInstancesStopReplicaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_TruncateLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesTruncateLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).TruncateLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/TruncateLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).TruncateLog(ctx, req.(*SqlInstancesTruncateLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).Update(ctx, req.(*SqlInstancesUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_CreateEphemeral_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesCreateEphemeralCertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).CreateEphemeral(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/CreateEphemeral",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).CreateEphemeral(ctx, req.(*SqlInstancesCreateEphemeralCertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_RescheduleMaintenance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesRescheduleMaintenanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).RescheduleMaintenance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/RescheduleMaintenance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).RescheduleMaintenance(ctx, req.(*SqlInstancesRescheduleMaintenanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_VerifyExternalSyncSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesVerifyExternalSyncSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).VerifyExternalSyncSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/VerifyExternalSyncSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).VerifyExternalSyncSettings(ctx, req.(*SqlInstancesVerifyExternalSyncSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlInstancesService_StartExternalSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlInstancesStartExternalSyncRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlInstancesServiceServer).StartExternalSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlInstancesService/StartExternalSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlInstancesServiceServer).StartExternalSync(ctx, req.(*SqlInstancesStartExternalSyncRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlInstancesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1beta4.SqlInstancesService",
	HandlerType: (*SqlInstancesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddServerCa",
			Handler:    _SqlInstancesService_AddServerCa_Handler,
		},
		{
			MethodName: "Clone",
			Handler:    _SqlInstancesService_Clone_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _SqlInstancesService_Delete_Handler,
		},
		{
			MethodName: "DemoteMaster",
			Handler:    _SqlInstancesService_DemoteMaster_Handler,
		},
		{
			MethodName: "Export",
			Handler:    _SqlInstancesService_Export_Handler,
		},
		{
			MethodName: "Failover",
			Handler:    _SqlInstancesService_Failover_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SqlInstancesService_Get_Handler,
		},
		{
			MethodName: "Import",
			Handler:    _SqlInstancesService_Import_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _SqlInstancesService_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SqlInstancesService_List_Handler,
		},
		{
			MethodName: "ListServerCas",
			Handler:    _SqlInstancesService_ListServerCas_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _SqlInstancesService_Patch_Handler,
		},
		{
			MethodName: "PromoteReplica",
			Handler:    _SqlInstancesService_PromoteReplica_Handler,
		},
		{
			MethodName: "ResetSslConfig",
			Handler:    _SqlInstancesService_ResetSslConfig_Handler,
		},
		{
			MethodName: "Restart",
			Handler:    _SqlInstancesService_Restart_Handler,
		},
		{
			MethodName: "RestoreBackup",
			Handler:    _SqlInstancesService_RestoreBackup_Handler,
		},
		{
			MethodName: "RotateServerCa",
			Handler:    _SqlInstancesService_RotateServerCa_Handler,
		},
		{
			MethodName: "StartReplica",
			Handler:    _SqlInstancesService_StartReplica_Handler,
		},
		{
			MethodName: "StopReplica",
			Handler:    _SqlInstancesService_StopReplica_Handler,
		},
		{
			MethodName: "TruncateLog",
			Handler:    _SqlInstancesService_TruncateLog_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SqlInstancesService_Update_Handler,
		},
		{
			MethodName: "CreateEphemeral",
			Handler:    _SqlInstancesService_CreateEphemeral_Handler,
		},
		{
			MethodName: "RescheduleMaintenance",
			Handler:    _SqlInstancesService_RescheduleMaintenance_Handler,
		},
		{
			MethodName: "VerifyExternalSyncSettings",
			Handler:    _SqlInstancesService_VerifyExternalSyncSettings_Handler,
		},
		{
			MethodName: "StartExternalSync",
			Handler:    _SqlInstancesService_StartExternalSync_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1beta4/cloud_sql.proto",
}

// SqlOperationsServiceClient is the client API for SqlOperationsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlOperationsServiceClient interface {
	// Retrieves an instance operation that has been performed on an instance.
	Get(ctx context.Context, in *SqlOperationsGetRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all instance operations that have been performed on the given Cloud
	// SQL instance in the reverse chronological order of the start time.
	List(ctx context.Context, in *SqlOperationsListRequest, opts ...grpc.CallOption) (*OperationsListResponse, error)
}

type sqlOperationsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlOperationsServiceClient(cc grpc.ClientConnInterface) SqlOperationsServiceClient {
	return &sqlOperationsServiceClient{cc}
}

func (c *sqlOperationsServiceClient) Get(ctx context.Context, in *SqlOperationsGetRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlOperationsService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlOperationsServiceClient) List(ctx context.Context, in *SqlOperationsListRequest, opts ...grpc.CallOption) (*OperationsListResponse, error) {
	out := new(OperationsListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlOperationsService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlOperationsServiceServer is the server API for SqlOperationsService service.
type SqlOperationsServiceServer interface {
	// Retrieves an instance operation that has been performed on an instance.
	Get(context.Context, *SqlOperationsGetRequest) (*Operation, error)
	// Lists all instance operations that have been performed on the given Cloud
	// SQL instance in the reverse chronological order of the start time.
	List(context.Context, *SqlOperationsListRequest) (*OperationsListResponse, error)
}

// UnimplementedSqlOperationsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlOperationsServiceServer struct {
}

func (*UnimplementedSqlOperationsServiceServer) Get(context.Context, *SqlOperationsGetRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSqlOperationsServiceServer) List(context.Context, *SqlOperationsListRequest) (*OperationsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

func RegisterSqlOperationsServiceServer(s *grpc.Server, srv SqlOperationsServiceServer) {
	s.RegisterService(&_SqlOperationsService_serviceDesc, srv)
}

func _SqlOperationsService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlOperationsGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlOperationsServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlOperationsService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlOperationsServiceServer).Get(ctx, req.(*SqlOperationsGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlOperationsService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlOperationsListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlOperationsServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlOperationsService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlOperationsServiceServer).List(ctx, req.(*SqlOperationsListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlOperationsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1beta4.SqlOperationsService",
	HandlerType: (*SqlOperationsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _SqlOperationsService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SqlOperationsService_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1beta4/cloud_sql.proto",
}

// SqlSslCertsServiceClient is the client API for SqlSslCertsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlSslCertsServiceClient interface {
	// Deletes the SSL certificate. For First Generation instances, the
	// certificate remains valid until the instance is restarted.
	Delete(ctx context.Context, in *SqlSslCertsDeleteRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a particular SSL certificate.  Does not include the private key
	// (required for usage).  The private key must be saved from the response to
	// initial creation.
	Get(ctx context.Context, in *SqlSslCertsGetRequest, opts ...grpc.CallOption) (*SslCert, error)
	// Creates an SSL certificate and returns it along with the private key and
	// server certificate authority.  The new certificate will not be usable until
	// the instance is restarted.
	Insert(ctx context.Context, in *SqlSslCertsInsertRequest, opts ...grpc.CallOption) (*SslCertsInsertResponse, error)
	// Lists all of the current SSL certificates for the instance.
	List(ctx context.Context, in *SqlSslCertsListRequest, opts ...grpc.CallOption) (*SslCertsListResponse, error)
}

type sqlSslCertsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlSslCertsServiceClient(cc grpc.ClientConnInterface) SqlSslCertsServiceClient {
	return &sqlSslCertsServiceClient{cc}
}

func (c *sqlSslCertsServiceClient) Delete(ctx context.Context, in *SqlSslCertsDeleteRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlSslCertsService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlSslCertsServiceClient) Get(ctx context.Context, in *SqlSslCertsGetRequest, opts ...grpc.CallOption) (*SslCert, error) {
	out := new(SslCert)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlSslCertsService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlSslCertsServiceClient) Insert(ctx context.Context, in *SqlSslCertsInsertRequest, opts ...grpc.CallOption) (*SslCertsInsertResponse, error) {
	out := new(SslCertsInsertResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlSslCertsService/Insert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlSslCertsServiceClient) List(ctx context.Context, in *SqlSslCertsListRequest, opts ...grpc.CallOption) (*SslCertsListResponse, error) {
	out := new(SslCertsListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1beta4.SqlSslCertsService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlSslCertsServiceServer is the server API for SqlSslCertsService service.
type SqlSslCertsServiceServer interface {
	// Deletes the SSL certificate. For First Generation instances, the
	// certificate remains valid until the instance is restarted.
	Delete(context.Context, *SqlSslCertsDeleteRequest) (*Operation, error)
	// Retrieves a particular SSL certificate.  Does not include the private key
	// (required for usage).  The private key must be saved from the response to
	// initial creation.
	Get(context.Context, *SqlSslCertsGetRequest) (*SslCert, error)
	// Creates an SSL certificate and returns it along with the private key and
	// server certificate authority.  The new certificate will not be usable until
	// the instance is restarted.
	Insert(context.Context, *SqlSslCertsInsertRequest) (*SslCertsInsertResponse, error)
	// Lists all of the current SSL certificates for the instance.
	List(context.Context, *SqlSslCertsListRequest) (*SslCertsListResponse, error)
}

// UnimplementedSqlSslCertsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlSslCertsServiceServer struct {
}

func (*UnimplementedSqlSslCertsServiceServer) Delete(context.Context, *SqlSslCertsDeleteRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSqlSslCertsServiceServer) Get(context.Context, *SqlSslCertsGetRequest) (*SslCert, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSqlSslCertsServiceServer) Insert(context.Context, *SqlSslCertsInsertRequest) (*SslCertsInsertResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (*UnimplementedSqlSslCertsServiceServer) List(context.Context, *SqlSslCertsListRequest) (*SslCertsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

func RegisterSqlSslCertsServiceServer(s *grpc.Server, srv SqlSslCertsServiceServer) {
	s.RegisterService(&_SqlSslCertsService_serviceDesc, srv)
}

func _SqlSslCertsService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlSslCertsDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlSslCertsServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlSslCertsService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlSslCertsServiceServer).Delete(ctx, req.(*SqlSslCertsDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlSslCertsService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlSslCertsGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlSslCertsServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlSslCertsService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlSslCertsServiceServer).Get(ctx, req.(*SqlSslCertsGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlSslCertsService_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlSslCertsInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlSslCertsServiceServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlSslCertsService/Insert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlSslCertsServiceServer).Insert(ctx, req.(*SqlSslCertsInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlSslCertsService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlSslCertsListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlSslCertsServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1beta4.SqlSslCertsService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlSslCertsServiceServer).List(ctx, req.(*SqlSslCertsListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlSslCertsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1beta4.SqlSslCertsService",
	HandlerType: (*SqlSslCertsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _SqlSslCertsService_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SqlSslCertsService_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _SqlSslCertsService_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SqlSslCertsService_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1beta4/cloud_sql.proto",
}
