#
# @file    TestL3Trigger.py
# @brief   SBML Trigger unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestL3Trigger.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestL3Trigger(unittest.TestCase):

  global T
  T = None

  def setUp(self):
    self.T = libsbml.Trigger(3,1)
    if (self.T == None):
      pass    
    pass  

  def tearDown(self):
    _dummyList = [ self.T ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_L3Trigger_create(self):
    self.assertTrue( self.T.getTypeCode() == libsbml.SBML_TRIGGER )
    self.assertTrue( self.T.getMetaId() == "" )
    self.assertTrue( self.T.getNotes() == None )
    self.assertTrue( self.T.getAnnotation() == None )
    self.assertTrue( self.T.getMath() == None )
    self.assertTrue( self.T.getInitialValue() == True )
    self.assertTrue( self.T.getPersistent() == True )
    self.assertTrue( self.T.isSetInitialValue() == False )
    self.assertTrue( self.T.isSetPersistent() == False )
    pass  

  def test_L3Trigger_setInitialValue(self):
    i = self.T.setInitialValue(False)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( self.T.getInitialValue() == False )
    self.assertTrue( self.T.isSetInitialValue() == True )
    i = self.T.setInitialValue(True)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( self.T.getInitialValue() == True )
    self.assertTrue( self.T.isSetInitialValue() == True )
    pass  

  def test_L3Trigger_setInitialValue1(self):
    t = libsbml.Trigger(2,4)
    i = t.setInitialValue(False)
    self.assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE )
    self.assertTrue( self.T.getInitialValue() == True )
    self.assertTrue( self.T.isSetInitialValue() == False )
    _dummyList = [ t ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_L3Trigger_setPersistent(self):
    i = self.T.setPersistent(False)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( self.T.getPersistent() == False )
    self.assertTrue( self.T.isSetPersistent() == True )
    i = self.T.setPersistent(True)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( self.T.getPersistent() == True )
    self.assertTrue( self.T.isSetPersistent() == True )
    pass  

  def test_L3Trigger_setPersistent1(self):
    t = libsbml.Trigger(2,4)
    i = t.setPersistent(False)
    self.assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE )
    self.assertTrue( self.T.getPersistent() == True )
    self.assertTrue( self.T.isSetPersistent() == False )
    _dummyList = [ t ]; _dummyList[:] = []; del _dummyList
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.TestLoader.loadTestsFromTestCase(TestL3Trigger))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)

