/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QDebug>
#include <QObject>
#include <QAction>
#include <QSettings>
#include <QMainWindow>

/////////////////////// pappsomspp includes


/////////////////////// libXpertMassCore includes


/////////////////////// Local includes


namespace Ui
{
class ApplicationPreferencesWnd;
class ApplicationPreferencesWndGeneralPageWidget;
class ApplicationPreferencesWndDiscoveriesPageWidget;
class DecimalPlacesPreferencesWidget;
class MaxThreadCountPreferencesWidget;
}

namespace MsXpS
{
namespace MineXpert
{


class ApplicationPreferencesWnd: public QMainWindow
{
  Q_OBJECT

  public:
  enum Pages
  {
    GENERAL = 0x0,
    SHORTCUTS,
    DISCOVERIES,
    COUNT
  };

  ApplicationPreferencesWnd(const QString &application_name,
                            const QString &description,
                            QWidget *parent_p = nullptr);

  virtual ~ApplicationPreferencesWnd();

  void writeSettings() const;
  void readSettings();

  void setupWindow();
  void setupGeneralPage();
  void setupMaxThreadCountWidget();
  void setupDecimalPlacesPreferencesWidget();
  void setupDiscoveriesPage();
  void setupShortcutPage();

  int insertSectionListItem(const QString &label,
                            const QIcon &icon,
                            QWidget *section_widget_p,
                            int index);

  public slots:
      void apply();

  protected:
  Ui::ApplicationPreferencesWnd *mp_ui;
      Ui::ApplicationPreferencesWndGeneralPageWidget *mp_generalPage_ui;
  Ui::ApplicationPreferencesWndDiscoveriesPageWidget *mp_discoveriesPage_ui;
  Ui::DecimalPlacesPreferencesWidget *mp_decimalPlacesPreferencesWidget_ui;
  Ui::MaxThreadCountPreferencesWidget *mp_maxThreadCountPreferencesWidget_ui;

  QString m_applicationName;
  QString m_windowDescription;

  void applyGeneralPage();
  void applyShortcutsPage();
  void applyDiscoveriesPage();
};


} // namespace MineXpert
} // namespace MsXpS
