# Autotools Notes

These notes are intended to describe the autotools build system and to assist developers in modifying and maintaining it.

## Tutorial

There are many great tutorials on how to use the autotools to configure and make software.  Please refer to them.

## configure.ac

We make all attempts to not commit generated files to our git repo.  This includes files generated by the autotools.  The important, non-generated files are the [configure.ac](configure.ac) and [Makefile.am](Makefile.am) templates for autoconf and automake.  In addition, the [m4](m4) directory contains all of the custom autoconf commands that appear in the configure.ac template.

configure.ac is relatively well-organized and broken into sections via comments.  Perhaps the trickiest hack is the unwrapping of the MPI compiler wrappers.  Unfortunately, libtool at times relies on comparing the name of the compiler against a known list instead of testing for behavior.  That means the MPI compiler wrappers, e.g., mpicc, are unknown to libtool.  The custom m4 function `GA_MPI_UNWRAP` in [m4/ga_mpi_unwrap.m4](m4/ga_mpi_unwrap.m4) attempts to use the `-show` argument to display the underlying compiler.  If it fails, it then compares the output of all known compilers' `--version` commands against the MPI compiler.  We hack certain libtool variables to test against the unwrapped compiler and then replace the results again with the compiler wrappers.

## Makefile.am

[Makefile.am](Makefile.am) is relatively well-organized and broken into sections.  We preferred to declare all variables at the top of the file and later append to them using `+=`.   We do not use recursive make; we favor using a single top-level Makefile.

## autogen.sh

[autogen.sh](autogen.sh) runs the auxiliary script
[travis/install-autotools.sh](travis/install-autotools.sh).  Next, the
autogen.sh script will run `autoreconf -vif` to generate the various
[configure](configure) scripts as well as the Makefile.in templates.  Finally, autogen.sh applies some patches to the generated build files.  See autogen.sh file for details.

## install-autotools.sh

[travis/install-autotools.sh](travis/install-autotools.sh) downloads and installs specific versions of autoconf (2.69), automake (1.11.6), and libtool (2.4.6).  These versions are known to produce suitable build files, e.g., configure, Makefile.in.  This script is in the [travis](travis) subdirectory because this script is intented to be run by the travis continous integration service, however the script is generally useful for developers to run as part of the autogen.sh script.

The primary reason for specific versions is that we hacked our Makefile.am template to create a custom test suite.  We copied code that was generated by automake 1.11.6 and pasted it directly into our Makefile.am template to override the built-in test suite features of automake.  This was to let our applications launch using the environment variable MPIEXEC, detected during the configure step.  Additionally, we split our test suite into 'serial' (no MPI) tests as well as 'parallel' (MPI) tests, so these different classes of tests required different launch mechanisms.  Our reliance on this automake 1.11.6 code caused us to be dependent on this version, all so we could type `make check` from the command line.
