% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat-dbplyr.R
\name{ident}
\alias{ident}
\title{Flag a character vector as SQL identifiers}
\usage{
ident(...)
}
\arguments{
\item{...}{A character vector, or name-value pairs.}
}
\description{
\code{ident()} takes strings and turns them as database identifiers (e.g. table
or column names) quoting them using the identifer rules for your database.
\code{ident_q()} does the same, but assumes the names have already been
quoted, preventing them from being quoted again.

These are generally for internal use only; if you need to supply an
table name that is qualified with schema or catalog, or has already been
quoted for some other reason, use \code{I()}.
}
\examples{
# Identifiers are escaped with "
\dontshow{if (requireNamespace("dbplyr", quietly = TRUE)) withAutoprint(\{ # examplesIf}
ident("x")
\dontshow{\}) # examplesIf}
}
