% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay5.R
\name{Layers-StdAssay}
\alias{Layers-StdAssay}
\alias{LayerData.StdAssay}
\alias{LayerData<-.StdAssay}
\alias{Layers.StdAssay}
\title{Query and Manipulate Assay Layers}
\usage{
\method{LayerData}{StdAssay}(
  object,
  layer = NULL,
  cells = NULL,
  features = NULL,
  fast = FALSE,
  slot = deprecated(),
  ...
)

\method{LayerData}{StdAssay}(object, layer, features = NULL, cells = NULL, ...) <- value

\method{Layers}{StdAssay}(object, search = NA, ...)
}
\arguments{
\item{object}{An object}

\item{layer}{Name of layer to fetch or set}

\item{features, cells}{Vectors of features/cells to include}

\item{fast}{Determine how to return the layer data; choose from:
\describe{
 \item{\code{FALSE}}{Apply any transpositions and attempt to add
  feature/cell names (if supported) back to the layer data}
 \item{\code{NA}}{Attempt to add feature/cell names back to the layer data,
  skip any transpositions}
 \item{\code{TRUE}}{Do not apply any transpositions or add feature/cell
  names to the layer data}
}}

\item{slot}{\Sexpr[stage=build,results=rd]{lifecycle::badge("deprecated")}}

\item{...}{Arguments passed to other methods}

\item{value}{New two-dimensional data to be added as a layer}

\item{search}{A pattern to search layer names for; pass one of:
\itemize{
 \item \dQuote{\code{NA}} to pull all layers
 \item \dQuote{\code{NULL}} to pull the default layer(s)
 \item a \link[base:grep]{regular expression} that matches layer names
}}
}
\value{
\code{LayerData}: the layer data for \code{layer} from \code{object}

\code{Layer<-}: \code{object} with \code{value} added as a layer
named \code{layer}

\code{Layers}: the names of the layers present in \code{object}
}
\description{
Query and Manipulate Assay Layers
}
\keyword{internal}
