// Copyright 2019-2025 The Wait4X Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Package wait4x provides functionality to wait for services and ports to become available
// or reach specific states. It supports configurable timeout durations and polling intervals,
// making it suitable for service dependency management, health checking, and integration testing.
//
// Features:
//   - Port availability checking
//   - Service state monitoring
//   - Configurable timeout and interval settings
//   - Support for multiple protocols and service types
//
// For more information and examples, visit: https://wait4x.dev
package wait4x // import "wait4x.dev/v3"
