# Self-assessment

## Self-assessment outline

### Table of contents

* [Metadata](#metadata)
  * [Security links](#security-links)
* [Overview](#overview)
  * [Actors](#actors)
  * [Actions](#actions)
  * [Background](#background)
  * [Goals](#goals)
  * [Non-goals](#non-goals)
* [Self-assessment use](#self-assessment-use)
* [Security functions and features](#security-functions-and-features)
* [Project compliance](#project-compliance)
* [Secure development practices](#secure-development-practices)
* [Security issue resolution](#security-issue-resolution)
* [Appendix](#appendix)

### Metadata

A table at the top for quick reference information, later used for indexing.

| Title | Detail |
| -- | -- |
| Assessment Stage | Incomplete. |
| Software | https://github.com/WasmEdge/WasmEdge |
| Security Provider | No.  |
| Languages | C++ |
| SBOM | The software bill of materials for WasmEdge can be found at [LICENSE.spdx](https://github.com/WasmEdge/WasmEdge/blob/master/LICENSE.spdx) |

#### Security links

| Doc | URL |
| -- | -- |
| Security file | https://github.com/WasmEdge/WasmEdge/blob/master/SECURITY.md |
| Embargo policy | https://github.com/WasmEdge/WasmEdge/blob/master/docs/embargo-policy.md |
| Security contacts | https://github.com/WasmEdge/WasmEdge/blob/master/docs/SECURITY_CONTACTS.md |

### Overview

WasmEdge is a lightweight, high-performance, and extensible WebAssembly runtime.
It is the fastest Wasm VM today. Its use cases include modern web application
architectures (Isomorphic & Jamstack applications), microservices on the edge
cloud, serverless SaaS APIs, embedded functions, smart contracts, and smart
devices.

#### Background

The WasmEdge Runtime provides a well-defined execution sandbox for its contained
WebAssembly bytecode program. The runtime offers isolation and protection for
operating system resources (e.g., file system, sockets, environment variables,
processes) and memory space. The most important use case for WasmEdge is to
safely execute user-defined or community-contributed code as plug-ins in a
software product (e.g., SaaS, software-defined vehicles, edge nodes, or even
blockchain nodes). It enables third-party developers, vendors, suppliers, and
community members to extend and customize the software product.

#### Actors

- WasmEdge Tool
    - Provides CLI tools for users.
    - The CLI tools offer a user-friendly interface to interact with WasmEdge
      functionalities.
    - Includes commands for compiling, running, and debugging WebAssembly
      applications.
- WasmEdge Loader
    - Loads the WebAssembly bytecode file.
    - Parses the loaded bytecode to Abstract Syntax Tree (AST).
    - Ensures that the bytecode is correctly structured for further processing.
- WasmEdge Validator
    - Validates the parsed bytecode AST to ensure it complies with WebAssembly
      specifications.
    - Checks for semantic correctness and security constraints.
    - Ensures that the bytecode does not contain any invalid or malicious
      instructions.
- WasmEdge Engine
    - The actual WebAssembly runtime that executes the bytecode.
    - Interprets the bytecode and performs the corresponding operations.
    - Manages the execution environment, including memory, stack, and system
      resources.
    - Ensures efficient and secure execution of WebAssembly modules.

#### Actions

To execute WebAssembly code, WasmEdge follows a series of steps involving
multiple components, each with specific responsibilities. Here is a detailed
description of the process, focusing on data flow and interactions between
components:

1. Interacting with Users (WasmEdge Tool)
    - Data Input: The WasmEdge Tool provides a Command-Line Interface (CLI) for
      users to interact with the WasmEdge functionalities.
    - Action: Users can issue commands to compile, run, and debug WebAssembly
      applications. These commands are processed by the CLI tools, which
      internally utilize the Loader, Validator, and Engine components to carry
      out the requested actions.
    - Output: The CLI tools offer feedback to the users, such as execution
      results, debug information, and error messages.

2. Loading the WebAssembly Bytecode (WasmEdge Loader)
    - Data Input: The process begins with the WasmEdge Loader component, which
      receives a WebAssembly bytecode file as input.
    - Action: The Loader reads and parses this bytecode file, converting it into
      an Abstract Syntax Tree (AST).
    - Output: The AST, which represents the structured form of the bytecode, is
      produced as output for further processing.

3. Validating the Bytecode (WasmEdge Validator)
    - Data Input: The AST generated by the Loader is passed to the WasmEdge
      Validator.
    - Action: The Validator component checks the AST to ensure that it complies
      with WebAssembly specifications. This involves verifying semantic
      correctness and security constraints, ensuring there are no invalid or
      malicious instructions.
    - Output: If the bytecode is valid, the Validator produces a validated AST.
      If invalid, it generates error messages indicating the issues found.

4. Executing the Bytecode (WasmEdge Engine)
    - Data Input: The validated AST is passed to the WasmEdge Engine, which is
      the core component responsible for executing the WebAssembly code.
    - Action: The Engine interprets the bytecode and performs the corresponding
      operations. It manages the execution environment, including memory, stack,
      and system resources. This ensures efficient and secure execution of the
      WebAssembly modules.
    - Output: The execution results, which could include changes in memory,
      generated outputs, or responses from invoked functions.

The interaction between these components ensures a smooth and secure execution
flow for WebAssembly programs in WasmEdge. The Loader initiates the process by
parsing the bytecode, the Validator ensures its compliance with standards, the
Engine executes the validated code, and the Tool provides a user-friendly
interface for these operations. This modular approach allows for efficient
handling and execution of WebAssembly code, making WasmEdge a robust and
high-performance WebAssembly runtime.

#### Goals

- Provides a well-defined execution sandbox for its contained WebAssembly
  bytecode program.
- Offers isolation and protection for operating system resources and memory
  space.
- Execute user-defined or community-contributed code as plugins.

#### Non-goals

- Compile the C++ code into WebAssembly bytecode.

### Self-assessment use

This self-assessment is created by the WasmEdge team to perform an internal
analysis of the project's security.  It is not intended to provide a security
audit of WasmEdge, or function as an independent assessment or attestation of
WasmEdge's security health.

This document serves to provide WasmEdge users with an initial understanding of
WasmEdge's security, where to find existing security documentation, WasmEdge
plans for security, and general overview of WasmEdge security practices, both
for development of WasmEdge as well as security of WasmEdge.

This document provides the CNCF TAG-Security with an initial understanding of
WasmEdge to assist in a joint-assessment, necessary for projects under
incubation.  Taken together, this document and the joint-assessment serve as a
cornerstone for if and when WasmEdge seeks graduation and is preparing for a
security audit.

### Security functions and features

- WasmEdge is a standalone WebAssembly runtime where all WebAssembly bytecode
  runs independently within this execution sandbox, rather than being managed by
  the OS. Access to system resources, whether files, hardware, or internet
  connections, can only be achieved through the WebAssembly system interfaces
  provided by this virtual machine.
- If users want to access the host OS's filesystem within the WasmEdge runtime,
  they can add the `--dir guest_path:host_path:readonly` option in the WasmEdge
  CLI to assign the read-only configuration.

### Project compliance

* Currently, WasmEdge does not meet any security standards or sub-sections.

### Secure development practices

- Development Pipeline
    - WasmEdge Require contributors to sign off on web-based commits.
    - The pull request must be approved by WasmEdge maintainer, committer or
      reviewers before merge.
    - The pull request must pass the CI jobs before merge.
    - WasmEdge also participates in OSS-Fuzz
      https://github.com/google/oss-fuzz/tree/master/projects/wasmedge. OSS-Fuzz
      aims to make common open-source software more secure and stable by
      combining modern fuzzing techniques with scalable, distributed execution.
      Participating in OSS-Fuzz allows us to better identify potential issues in
      WasmEdge through fuzzing.
- Communication Channels
    - Internal
        - Direct message on [WasmEdge Discord
          server](https://discord.gg/h4KDyB8XTt).
    - Inbound
        - [WasmEdge Discord server](https://discord.gg/h4KDyB8XTt).
        - **#wasmedge** channel on the [CNCF Slack](https://slack.cncf.io/).
    - Outbound
        - [WasmEdge Discord server](https://discord.gg/h4KDyB8XTt).
        - **#wasmedge** channel on the [CNCF Slack](https://slack.cncf.io/).
        - Mailing list <wasmedge@googlegroup.com>.
        - We host a monthly community meeting to showcase new features, demo new
          use cases, and a Q&A part.
            - The first Tuesday of each month at 11PM Hong Kong Time/ 7AM PST.

### Security issue resolution

As stated in the [WasmEdge security
document](https://github.com/WasmEdge/WasmEdge/blob/master/SECURITY.md), the
process for handling security reports is as follows:

Users can use the below process to report a vulnerability to WasmEdge:

Email:

1. Send email to <wasmedge-security@lists.cncf.io>
    * Emails should contain:
        * description of the problem
        * precise and detailed steps (include screenshots) that created the
          problem
        * the affected version(s)
        * any possible mitigations, if known
1. You will receive a reply from one of the maintainers within 24 hours
   acknowledging receipt of the email. After that, we will give a detailed
   response about the subsequent process within 48 hours.
1. Please do not submit security vulnerabilities directly as Github Issues.

Web:

1. Please visit [GitHub Security Advisory of
   WasmEdge](https://github.com/WasmEdge/WasmEdge/security/advisories/new)
   * You will receive a confirmation email upon submission

WasmEdge follows a **`90 days` disclosure timeline**. For known public security
vulnerabilities, we will disclose the disclosure as soon as possible after
receiving the report. Vulnerabilities discovered for the first time will be
disclosed in accordance with the following process:

* The received security vulnerability report shall be handed over to the
  security team for follow-up coordination and repair work.
* After the vulnerability is confirmed, we will create a draft Security Advisory
  on Github that lists the details of the vulnerability.
* Invite related personnel to discuss about the fix.
* Fork the temporary private repository on Github, and collaborate to fix the
  vulnerability.
* After the fix code is merged into all supported versions, the vulnerability
  will be publicly posted in the GitHub Advisory Database.

### Appendix

- TBA.
