package ONVIF::Media::Types::AnalyticsDeviceEngineConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %EngineConfiguration_of :ATTR(:get<EngineConfiguration>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        EngineConfiguration
        Extension

    ) ],
    {
        'EngineConfiguration' => \%EngineConfiguration_of,
        'Extension' => \%Extension_of,
    },
    {
        'EngineConfiguration' => 'ONVIF::Media::Types::EngineConfiguration',
        'Extension' => 'ONVIF::Media::Types::AnalyticsDeviceEngineConfigurationExtension',
    },
    {

        'EngineConfiguration' => 'EngineConfiguration',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::AnalyticsDeviceEngineConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AnalyticsDeviceEngineConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * EngineConfiguration


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::AnalyticsDeviceEngineConfiguration
   EngineConfiguration =>  { # ONVIF::Media::Types::EngineConfiguration
     VideoAnalyticsConfiguration =>  { # ONVIF::Media::Types::VideoAnalyticsConfiguration
       AnalyticsEngineConfiguration =>  { # ONVIF::Media::Types::AnalyticsEngineConfiguration
         AnalyticsModule =>  { # ONVIF::Media::Types::Config
           Parameters =>  { # ONVIF::Media::Types::ItemList
             SimpleItem => ,
             ElementItem =>  {
             },
             Extension =>  { # ONVIF::Media::Types::ItemListExtension
             },
           },
         },
         Extension =>  { # ONVIF::Media::Types::AnalyticsEngineConfigurationExtension
         },
       },
       RuleEngineConfiguration =>  { # ONVIF::Media::Types::RuleEngineConfiguration
         Rule =>  { # ONVIF::Media::Types::Config
           Parameters =>  { # ONVIF::Media::Types::ItemList
             SimpleItem => ,
             ElementItem =>  {
             },
             Extension =>  { # ONVIF::Media::Types::ItemListExtension
             },
           },
         },
         Extension =>  { # ONVIF::Media::Types::RuleEngineConfigurationExtension
         },
       },
     },
     AnalyticsEngineInputInfo =>  { # ONVIF::Media::Types::AnalyticsEngineInputInfo
       InputInfo =>  { # ONVIF::Media::Types::Config
         Parameters =>  { # ONVIF::Media::Types::ItemList
           SimpleItem => ,
           ElementItem =>  {
           },
           Extension =>  { # ONVIF::Media::Types::ItemListExtension
           },
         },
       },
       Extension =>  { # ONVIF::Media::Types::AnalyticsEngineInputInfoExtension
       },
     },
   },
   Extension =>  { # ONVIF::Media::Types::AnalyticsDeviceEngineConfigurationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

